/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.RpcOutput;
import org.opendaylight.yangtools.binding.data.codec.api.BindingCodecTree;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataCodec;
import org.opendaylight.yangtools.binding.data.codec.api.BindingLazyContainerNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.yangtools.binding.data.codec.dynamic.DynamicBindingDataCodec;
import org.opendaylight.yangtools.binding.data.codec.osgi.OSGiBindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.ForwardingBindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.LazyActionInputContainerNode;
import org.opendaylight.yangtools.binding.data.codec.spi.LazyActionOutputContainerNode;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, service={BindingDataCodec.class, DynamicBindingDataCodec.class, BindingCodecTree.class, BindingNormalizedNodeSerializer.class, BindingNormalizedNodeWriterFactory.class, BindingDOMCodecServices.class})
public final class GlobalBindingDOMCodecServices
extends ForwardingBindingDOMCodecServices
implements DynamicBindingDataCodec {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingDOMCodecServices.class);
    private BindingDOMCodecServices delegate;
    private Uint64 generation;

    @Activate
    public GlobalBindingDOMCodecServices(@Reference(updated="update") OSGiBindingDOMCodecServices services) {
        this.updateDelegate(services);
        LOG.info("Global Binding/DOM Codec activated with generation {}", (Object)this.generation);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Global Binding/DOM Codec deactivated");
    }

    void update(OSGiBindingDOMCodecServices services) {
        this.updateDelegate(services);
        LOG.info("Global Binding/DOM Codec updated to generation {}", (Object)this.generation);
    }

    private void updateDelegate(OSGiBindingDOMCodecServices services) {
        this.generation = services.generation();
        this.delegate = (BindingDOMCodecServices)services.service();
    }

    public BindingRuntimeContext runtimeContext() {
        return this.delegate().getRuntimeContext();
    }

    public BindingNormalizedNodeSerializer nodeSerializer() {
        return this.delegate();
    }

    public BindingCodecTree tree() {
        return this.delegate();
    }

    public BindingNormalizedNodeWriterFactory writerFactory() {
        return this.delegate();
    }

    public BindingLazyContainerNode<RpcInput> toLazyNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcInput input) {
        return new LazyActionInputContainerNode(identifier, input, (BindingNormalizedNodeSerializer)this, action);
    }

    public BindingLazyContainerNode<RpcOutput> toLazyNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcOutput output) {
        return new LazyActionOutputContainerNode(identifier, output, (BindingNormalizedNodeSerializer)this, action);
    }

    protected BindingDOMCodecServices delegate() {
        return (BindingDOMCodecServices)Verify.verifyNotNull((Object)this.delegate);
    }
}

