/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.loader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.binding.loader.RootBindingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LeafBindingClassLoader
extends BindingClassLoader {
    private static final Logger LOG;
    private static final VarHandle DEPENDENCIES;
    private final @NonNull RootBindingClassLoader root;
    private final @NonNull ClassLoader target;
    private volatile ImmutableSet<LeafBindingClassLoader> dependencies = ImmutableSet.of();

    LeafBindingClassLoader(RootBindingClassLoader root, ClassLoader target) {
        super(root);
        this.root = Objects.requireNonNull(root);
        this.target = Objects.requireNonNull(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.target.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            LOG.trace("Class {} not found in target, looking through dependencies", (Object)name);
            for (LeafBindingClassLoader loader : this.dependencies) {
                Object object = loader.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> loaded = loader.findLoadedClass(name);
                    if (loaded != null) {
                        LOG.trace("Class {} found in dependency {}", (Object)name, (Object)loader);
                        return loaded;
                    }
                }
            }
            throw e;
        }
    }

    @Override
    BindingClassLoader findClassLoader(Class<?> bindingClass) {
        return this.target.equals(bindingClass.getClassLoader()) ? this : this.root.findClassLoader(bindingClass);
    }

    @Override
    void appendLoaders(Set<LeafBindingClassLoader> newLoaders) {
        ImmutableSet local = this.dependencies;
        ImmutableSet updated;
        while (!local.equals((Object)(updated = ImmutableSet.builderWithExpectedSize((int)(local.size() + newLoaders.size())).addAll(local).addAll(newLoaders).build()))) {
            ImmutableSet witness = DEPENDENCIES.compareAndExchange(this, local, updated);
            if (witness == local) {
                return;
            }
            local = witness;
        }
        return;
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper).add("target", (Object)this.target);
    }

    static {
        Verify.verify((boolean)LeafBindingClassLoader.registerAsParallelCapable());
        LOG = LoggerFactory.getLogger(LeafBindingClassLoader.class);
        try {
            DEPENDENCIES = MethodHandles.lookup().findVarHandle(LeafBindingClassLoader.class, "dependencies", ImmutableSet.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

