/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.DiskFileReader;
import io.atomix.storage.journal.DiskFileWriter;
import io.atomix.storage.journal.FileAccess;
import io.atomix.storage.journal.JournalSegmentFile;
import io.netty.buffer.ByteBuf;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
final class DiskFileAccess
extends FileAccess {
    private static final int MIN_IO_SIZE = 8192;

    DiskFileAccess(JournalSegmentFile file, int maxEntrySize) {
        super(file, maxEntrySize);
    }

    @Override
    DiskFileReader newFileReader() {
        return new DiskFileReader(this.file, DiskFileAccess.allocateBuffer(this.file, this.maxEntrySize));
    }

    @Override
    DiskFileWriter newFileWriter() {
        return new DiskFileWriter(this.file, this.maxEntrySize, DiskFileAccess.allocateBuffer(this.file, this.maxEntrySize));
    }

    @Override
    public void close() {
    }

    private static ByteBuf allocateBuffer(JournalSegmentFile file, int maxEntrySize) {
        int bufferSize = DiskFileAccess.chooseBufferSize(maxEntrySize, file.maxSize());
        return file.allocator().heapBuffer(bufferSize, bufferSize);
    }

    private static int chooseBufferSize(int maxEntrySize, int maxSegmentSize) {
        if (maxSegmentSize <= 8192) {
            return maxSegmentSize;
        }
        int minBufferSize = maxEntrySize + 8;
        return minBufferSize <= 8192 ? 8192 : minBufferSize;
    }
}

