/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.DiskFileReader;
import io.atomix.storage.journal.FileWriter;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.StorageException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Objects;

final class DiskFileWriter
extends FileWriter {
    private static final ByteBuf ZERO_ENTRY_HEADER = Unpooled.wrappedBuffer((byte[])new byte[8]);
    private final DiskFileReader reader;
    private final FileChannel channel;
    private final ByteBuf buffer;

    DiskFileWriter(JournalSegmentFile file, int maxEntrySize, ByteBuf buffer) {
        super(file, maxEntrySize);
        this.buffer = Objects.requireNonNull(buffer);
        this.channel = file.channel();
        this.reader = new DiskFileReader(file, buffer);
    }

    @Override
    DiskFileReader reader() {
        return this.reader;
    }

    @Override
    void writeEmptyHeader(int position) {
        try {
            ZERO_ENTRY_HEADER.getBytes(0, this.channel, (long)position, 8);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    ByteBuf startWrite(int position, int size) {
        return this.buffer.clear().slice(0, size);
    }

    @Override
    void commitWrite(int position, ByteBuf entry) {
        try {
            entry.readBytes(this.channel, (long)position, entry.readableBytes());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    void flush() {
        if (this.channel.isOpen()) {
            try {
                this.channel.force(true);
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    void release() {
        this.reader.release();
    }
}

