/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.FileAccess;
import io.atomix.storage.journal.FileReader;
import io.atomix.storage.journal.FileWriter;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.JournalSegmentReader;
import io.atomix.storage.journal.JournalSegmentWriter;
import io.atomix.storage.journal.StorageException;
import io.atomix.storage.journal.StorageLevel;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import io.atomix.storage.journal.index.SparseJournalIndex;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JournalSegment {
    private static final Logger LOG = LoggerFactory.getLogger(JournalSegment.class);
    private final Set<JournalSegmentReader> readers = ConcurrentHashMap.newKeySet();
    private final AtomicInteger references = new AtomicInteger();
    private final @NonNull JournalSegmentFile file;
    private final @NonNull StorageLevel storageLevel;
    private final @NonNull JournalIndex journalIndex;
    private final int maxEntrySize;
    private State state;
    private boolean open = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JournalSegment(JournalSegmentFile file, StorageLevel storageLevel, int maxEntrySize, double indexDensity) {
        this.file = Objects.requireNonNull(file);
        this.storageLevel = Objects.requireNonNull(storageLevel);
        this.maxEntrySize = maxEntrySize;
        this.journalIndex = new SparseJournalIndex(indexDensity);
        try (FileAccess tmpAccess = file.newAccess(storageLevel, maxEntrySize);){
            FileReader fileReader = tmpAccess.newFileReader();
            try {
                this.state = new Inactive(JournalSegment.indexEntries(fileReader, this, maxEntrySize, this.journalIndex, Long.MAX_VALUE, null));
            }
            finally {
                fileReader.release();
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    long firstIndex() {
        return this.file.firstIndex();
    }

    long lastIndex() {
        Position lastPosition = this.journalIndex.last();
        return lastPosition != null ? lastPosition.index() : this.firstIndex() - 1L;
    }

    JournalSegmentFile file() {
        return this.file;
    }

    @Nullable Position lookup(long index) {
        return this.journalIndex.lookup(index);
    }

    private Active acquire() {
        return this.references.getAndIncrement() == 0 ? this.activate() : (Active)this.state;
    }

    private Active activate() {
        Active ret;
        try {
            ret = ((Inactive)this.state).activate(this);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        this.state = ret;
        return ret;
    }

    private void release() {
        if (this.references.decrementAndGet() == 0) {
            this.state = ((Active)this.state).deactivate();
            if (!this.open) {
                this.finishClose();
            }
        }
    }

    JournalSegmentWriter acquireWriter() {
        this.checkOpen();
        return this.acquire().writer();
    }

    void releaseWriter() {
        this.release();
    }

    JournalSegmentReader createReader() {
        this.checkOpen();
        JournalSegmentReader reader = new JournalSegmentReader(this, this.acquire().access().newFileReader(), this.maxEntrySize);
        reader.setPosition(64);
        this.readers.add(reader);
        return reader;
    }

    void closeReader(JournalSegmentReader reader) {
        if (this.readers.remove(reader)) {
            this.release();
        }
    }

    private void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("Segment not open");
        }
    }

    boolean isOpen() {
        return this.open;
    }

    void close() {
        if (!this.open) {
            return;
        }
        LOG.debug("Closing segment: {}", (Object)this);
        this.open = false;
        this.readers.forEach(JournalSegmentReader::close);
        if (this.references.get() == 0) {
            this.finishClose();
        }
    }

    private void finishClose() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    void delete() {
        this.close();
        LOG.debug("Deleting segment: {}", (Object)this);
        try {
            Files.deleteIfExists(this.file.path());
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.file.segmentId()).add("version", this.file.version()).add("index", this.file.firstIndex()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int indexEntries(FileWriter fileWriter, JournalSegment segment, JournalIndex journalIndex, long maxNextIndex, @Nullable Position start) {
        FileReader fileReader = fileWriter.reader();
        try {
            int n = JournalSegment.indexEntries(fileReader, segment, fileWriter.maxEntrySize(), journalIndex, maxNextIndex, start);
            return n;
        }
        finally {
            fileReader.invalidateCache();
        }
    }

    private static int indexEntries(FileReader fileReader, JournalSegment segment, int maxEntrySize, JournalIndex journalIndex, long maxNextIndex, @Nullable Position start) {
        ByteBuf buf;
        int position;
        long nextIndex;
        if (start != null) {
            nextIndex = start.index();
            position = start.position();
        } else {
            nextIndex = segment.firstIndex();
            position = 64;
        }
        JournalSegmentReader reader = new JournalSegmentReader(segment, fileReader, maxEntrySize);
        reader.setPosition(position);
        while (nextIndex <= maxNextIndex && (buf = reader.readBytes()) != null) {
            journalIndex.index(nextIndex++, position);
            position += 8 + buf.readableBytes();
        }
        return position;
    }

    @NonNullByDefault
    record Inactive(int position) implements State
    {
        Active activate(JournalSegment segment) throws IOException {
            FileAccess access = segment.file.newAccess(segment.storageLevel, segment.maxEntrySize);
            return new Active(access, new JournalSegmentWriter(access.newFileWriter(), segment, segment.journalIndex, this));
        }
    }

    static sealed interface State
    permits Active, Inactive {
    }

    @NonNullByDefault
    record Active(FileAccess access, JournalSegmentWriter writer) implements State
    {
        Active {
            Objects.requireNonNull(access);
            Objects.requireNonNull(writer);
        }

        Inactive deactivate() {
            Inactive inactive = new Inactive(this.writer.currentPosition());
            this.access.close();
            return inactive;
        }
    }
}

