/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.DiskFileAccess;
import io.atomix.storage.journal.FileAccess;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import io.atomix.storage.journal.MappedFileAccess;
import io.atomix.storage.journal.StorageLevel;
import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

final class JournalSegmentFile {
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "log";
    private final @NonNull JournalSegmentDescriptor descriptor;
    private final @NonNull ByteBufAllocator allocator;
    private final @NonNull RandomAccessFile file;
    private final @NonNull Path path;

    private JournalSegmentFile(Path path, ByteBufAllocator allocator, JournalSegmentDescriptor descriptor, RandomAccessFile file) {
        this.path = Objects.requireNonNull(path);
        this.allocator = Objects.requireNonNull(allocator);
        this.descriptor = Objects.requireNonNull(descriptor);
        this.file = Objects.requireNonNull(file);
    }

    static @NonNull JournalSegmentFile createNew(String name, File directory, ByteBufAllocator allocator, JournalSegmentDescriptor descriptor) throws IOException {
        File file = JournalSegmentFile.createSegmentFile(name, directory, descriptor.id());
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.setLength(descriptor.maxSegmentSize());
            raf.write(descriptor.toArray());
        }
        catch (IOException e) {
            raf.close();
            throw e;
        }
        return new JournalSegmentFile(file.toPath(), allocator, descriptor, raf);
    }

    static @NonNull JournalSegmentFile openExisting(Path path, ByteBufAllocator allocator) throws IOException {
        JournalSegmentDescriptor descriptor;
        RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");
        try {
            descriptor = JournalSegmentDescriptor.readFrom(raf.getChannel());
        }
        catch (IOException e) {
            raf.close();
            throw e;
        }
        return new JournalSegmentFile(path, allocator, descriptor, raf);
    }

    @NonNull Path path() {
        return this.path;
    }

    @NonNull ByteBufAllocator allocator() {
        return this.allocator;
    }

    int version() {
        return this.descriptor.version();
    }

    long segmentId() {
        return this.descriptor.id();
    }

    long firstIndex() {
        return this.descriptor.index();
    }

    int maxSize() {
        return this.descriptor.maxSegmentSize();
    }

    int size() throws IOException {
        return (int)this.file.length();
    }

    FileChannel channel() {
        return this.file.getChannel();
    }

    @NonNullByDefault
    FileAccess newAccess(StorageLevel level, int maxEntrySize) throws IOException {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case StorageLevel.DISK -> new DiskFileAccess(this, maxEntrySize);
            case StorageLevel.MAPPED -> MappedFileAccess.of(this, maxEntrySize);
        };
    }

    void close() throws IOException {
        this.file.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("descriptor", (Object)this.descriptor).toString();
    }

    public static boolean isSegmentFile(String name, File file) {
        return JournalSegmentFile.isSegmentFile(name, file.getName());
    }

    public static boolean isSegmentFile(String journalName, String fileName) {
        Objects.requireNonNull(journalName, "journalName cannot be null");
        Objects.requireNonNull(fileName, "fileName cannot be null");
        int partSeparator = fileName.lastIndexOf(45);
        int extensionSeparator = fileName.lastIndexOf(46);
        if (extensionSeparator == -1 || partSeparator == -1 || extensionSeparator < partSeparator || !fileName.endsWith(EXTENSION)) {
            return false;
        }
        for (int i = partSeparator + 1; i < extensionSeparator; ++i) {
            if (Character.isDigit(fileName.charAt(i))) continue;
            return false;
        }
        return fileName.startsWith(journalName);
    }

    static File createSegmentFile(String name, File directory, long id) {
        return new File(directory, String.format("%s-%d.log", Objects.requireNonNull(name, "name cannot be null"), id));
    }
}

