/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.Verify;
import io.atomix.storage.journal.FileReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.SegmentEntry;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JournalSegmentReader {
    private static final Logger LOG = LoggerFactory.getLogger(JournalSegmentReader.class);
    private final JournalSegment segment;
    private final int maxSegmentSize;
    private final int maxEntrySize;
    private FileReader fileReader;
    private int position;

    JournalSegmentReader(JournalSegment segment, FileReader fileReader, int maxEntrySize) {
        this.segment = Objects.requireNonNull(segment);
        this.fileReader = Objects.requireNonNull(fileReader);
        this.maxSegmentSize = segment.file().maxSize();
        this.maxEntrySize = maxEntrySize;
    }

    int position() {
        return this.position;
    }

    void setPosition(int position) {
        Verify.verify((position >= 64 && position < this.maxSegmentSize ? 1 : 0) != 0, (String)"Invalid position %s", (int)position);
        this.position = position;
        this.fileReader.invalidateCache();
    }

    void invalidateCache() {
        this.fileReader.invalidateCache();
    }

    @Nullable ByteBuf readBytes() {
        ByteBuf entryBuffer;
        int computed;
        int remaining = this.maxSegmentSize - this.position - 8;
        if (remaining < 0) {
            return null;
        }
        int maxLength = Math.min(remaining, this.maxEntrySize);
        ByteBuf buffer = this.fileReader.read(this.position, maxLength + 8);
        int length = buffer.getInt(0);
        if (length < 1 || length > maxLength) {
            this.invalidateCache();
            return null;
        }
        int checksum = buffer.getInt(4);
        if (checksum != (computed = SegmentEntry.computeChecksum((entryBuffer = buffer.slice(8, length)).nioBuffer()))) {
            LOG.warn("Expected checksum {}, computed {}", (Object)Integer.toHexString(checksum), (Object)Integer.toHexString(computed));
            this.invalidateCache();
            return null;
        }
        this.position += 8 + length;
        return entryBuffer;
    }

    void close() {
        FileReader local = this.fileReader;
        if (local != null) {
            this.fileReader = null;
            local.release();
            this.segment.closeReader(this);
        }
    }
}

