/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.FileWriter;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.SegmentEntry;
import io.atomix.storage.journal.StorageException;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JournalSegmentWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JournalSegmentWriter.class);
    private final FileWriter fileWriter;
    final @NonNull JournalSegment segment;
    private final @NonNull JournalIndex journalIndex;
    private int currentPosition;

    JournalSegmentWriter(FileWriter fileWriter, JournalSegment segment, JournalIndex journalIndex, int currentPosition) {
        this.fileWriter = Objects.requireNonNull(fileWriter);
        this.segment = Objects.requireNonNull(segment);
        this.journalIndex = Objects.requireNonNull(journalIndex);
        this.currentPosition = currentPosition;
    }

    JournalSegmentWriter(FileWriter fileWriter, JournalSegment segment, JournalIndex journalIndex, JournalSegment.Inactive segmentState) {
        this.fileWriter = Objects.requireNonNull(fileWriter);
        this.segment = Objects.requireNonNull(segment);
        this.journalIndex = Objects.requireNonNull(journalIndex);
        this.currentPosition = segmentState.position();
    }

    int currentPosition() {
        return this.currentPosition;
    }

    long nextIndex() {
        Position lastPosition = this.journalIndex.last();
        return lastPosition != null ? lastPosition.index() + 1L : this.segment.firstIndex();
    }

    <T> @Nullable Integer append(ToByteBufMapper<T> mapper, T entry) {
        long index = this.nextIndex();
        int position = this.currentPosition;
        int bodyPosition = position + 8;
        int avail = this.segment.file().maxSize() - bodyPosition;
        if (avail <= 0) {
            LOG.trace("Not enough space for {} at {}", (Object)index, (Object)position);
            return null;
        }
        int maxEntrySize = this.fileWriter.maxEntrySize();
        int writeLimit = Math.min(avail, maxEntrySize);
        ByteBuf diskEntry = this.fileWriter.startWrite(position, writeLimit + 8);
        ByteBuf bytes = diskEntry.slice(8, writeLimit);
        try {
            mapper.objectToBytes(entry, bytes);
        }
        catch (EOFException e) {
            if (writeLimit == maxEntrySize) {
                throw new StorageException.TooLarge("Serialized entry size exceeds maximum allowed bytes (" + maxEntrySize + ")", e);
            }
            LOG.trace("Tail serialization with {} bytes available failed", (Object)writeLimit, (Object)e);
            return null;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        int length = bytes.readableBytes();
        diskEntry.writerIndex(diskEntry.readerIndex() + 8 + length);
        int checksum = SegmentEntry.computeChecksum(diskEntry.nioBuffer(8, length));
        this.fileWriter.commitWrite(position, diskEntry.setInt(0, length).setInt(4, checksum));
        this.currentPosition = bodyPosition + length;
        this.journalIndex.index(index, position);
        return length;
    }

    void truncate(long index) {
        if (index >= this.segment.lastIndex()) {
            return;
        }
        Position nearest = this.journalIndex.truncate(index);
        this.currentPosition = index < this.segment.firstIndex() ? 64 : JournalSegment.indexEntries(this.fileWriter, this.segment, this.journalIndex, index, nearest);
        this.fileWriter.writeEmptyHeader(this.currentPosition);
    }

    void flush() {
        try {
            this.fileWriter.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }
}

