/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.FileAccess;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.MappedByteBuf;
import io.atomix.storage.journal.MappedFileReader;
import io.atomix.storage.journal.MappedFileWriter;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

final class MappedFileAccess
extends FileAccess {
    private MappedByteBuf mappedBuf;

    private MappedFileAccess(@NonNull JournalSegmentFile file, int maxEntrySize, MappedByteBuf mappedBuf) {
        super(file, maxEntrySize);
        this.mappedBuf = Objects.requireNonNull(mappedBuf);
    }

    @NonNullByDefault
    static MappedFileAccess of(JournalSegmentFile file, int maxEntrySize) throws IOException {
        return new MappedFileAccess(file, maxEntrySize, MappedByteBuf.of(file));
    }

    @Override
    MappedFileReader newFileReader() {
        return new MappedFileReader(this.file, this.mappedBuf.duplicate());
    }

    @Override
    MappedFileWriter newFileWriter() {
        return new MappedFileWriter(this.file, this.maxEntrySize, this.mappedBuf.duplicate(), this.mappedBuf);
    }

    @Override
    public void close() {
        MappedByteBuf toClose = this.mappedBuf;
        if (toClose != null) {
            this.mappedBuf = null;
            toClose.release();
        }
    }
}

