/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.Verify;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSegmentWriter;
import io.atomix.storage.journal.SegmentedByteBufJournal;
import java.util.Objects;
import org.opendaylight.controller.raft.journal.EntryWriter;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;

final class SegmentedByteBufWriter
implements EntryWriter {
    private final SegmentedByteBufJournal journal;
    private JournalSegment currentSegment;
    private JournalSegmentWriter currentWriter;

    SegmentedByteBufWriter(SegmentedByteBufJournal journal) {
        this.journal = Objects.requireNonNull(journal);
        this.currentSegment = journal.lastSegment();
        this.currentWriter = this.currentSegment.acquireWriter();
    }

    public long nextIndex() {
        return this.currentWriter.nextIndex();
    }

    public void commit(long index) {
        if (index > this.journal.getCommitIndex()) {
            this.journal.setCommitIndex(index);
            if (this.journal.isFlushOnCommit()) {
                this.flush();
            }
        }
    }

    public <T> int append(ToByteBufMapper<T> mapper, T entry) {
        Integer size = this.currentWriter.append(mapper, entry);
        return size != null ? size.intValue() : this.appendToNextSegment(mapper, entry);
    }

    private <T> int appendToNextSegment(ToByteBufMapper<T> mapper, T entry) {
        this.currentWriter.flush();
        this.currentSegment.releaseWriter();
        this.currentSegment = this.journal.createNextSegment();
        this.currentWriter = this.currentSegment.acquireWriter();
        return (Integer)Verify.verifyNotNull((Object)this.currentWriter.append(mapper, entry));
    }

    public void reset(long index) {
        long commitIndex = this.journal.getCommitIndex();
        if (index <= commitIndex) {
            throw new IndexOutOfBoundsException("Cannot reset to: " + index + ", committed index: " + commitIndex);
        }
        long prevIndex = index - 1L;
        long lastIndex = this.currentSegment.lastIndex();
        if (prevIndex == lastIndex) {
            return;
        }
        if (prevIndex > lastIndex) {
            throw new IndexOutOfBoundsException("Cannot reset to: " + index + ", lastIndex: " + lastIndex);
        }
        while (prevIndex < this.currentSegment.firstIndex() && this.currentSegment != this.journal.firstSegment()) {
            this.currentSegment.releaseWriter();
            this.journal.removeSegment(this.currentSegment);
            this.currentSegment = this.journal.lastSegment();
            this.currentWriter = this.currentSegment.acquireWriter();
        }
        this.currentWriter.truncate(prevIndex);
        this.journal.resetTail(index);
        this.journal.resetHead(index);
    }

    public void flush() {
        this.currentWriter.flush();
    }
}

