/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalWriter;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.raft.journal.EntryWriter;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;

@NonNullByDefault
final class SegmentedJournalWriter<E>
implements JournalWriter<E> {
    private final ToByteBufMapper<E> mapper;
    private final EntryWriter writer;

    SegmentedJournalWriter(EntryWriter writer, ToByteBufMapper<E> mapper) {
        this.writer = Objects.requireNonNull(writer);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public long getNextIndex() {
        return this.writer.nextIndex();
    }

    @Override
    public void commit(long index) {
        this.writer.commit(index);
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        long index = this.writer.nextIndex();
        return new Indexed<T>(index, entry, this.writer.append(this.mapper, entry));
    }

    @Override
    public void reset(long index) {
        this.writer.reset(index);
    }

    @Override
    public void flush() {
        this.writer.flush();
    }
}

