/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import io.atomix.utils.serializer.BufferAwareByteArrayOutputStream;
import io.atomix.utils.serializer.ByteArrayOutput;
import io.atomix.utils.serializer.KryoIOPool;

final class KryoOutputPool
extends KryoIOPool<ByteArrayOutput> {
    private static final int MAX_BUFFER_SIZE = 786432;
    static final int MAX_POOLED_BUFFER_SIZE = 524288;

    KryoOutputPool() {
    }

    @Override
    ByteArrayOutput create(int bufferSize) {
        return new ByteArrayOutput(bufferSize, 786432, new BufferAwareByteArrayOutputStream(bufferSize));
    }

    @Override
    boolean recycle(ByteArrayOutput output) {
        BufferAwareByteArrayOutputStream baos = output.getByteArrayOutputStream();
        if (baos.getBufferSize() >= 524288) {
            return false;
        }
        baos.reset();
        output.clear();
        return true;
    }
}

