/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.YangFeature;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.spi.source.DelegatedYangTextSource;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class ModuleInfoSnapshotResolver
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleInfoSnapshotResolver.class);
    private final YangTextSchemaContextResolver ctxResolver;
    private final @GuardedBy(value={"this"}) ListMultimap<SourceIdentifier, RegisteredModuleInfo> sourceToInfoReg = MultimapBuilder.hashKeys().arrayListValues().build();
    private final @GuardedBy(value={"this"}) ListMultimap<Class<? extends DataRoot<?>>, ImmutableSet<YangFeature<?, ?>>> moduleToFeatures = MultimapBuilder.hashKeys().arrayListValues().build();
    private @GuardedBy(value={"this"}) @Nullable ModuleInfoSnapshot currentSnapshot;

    public ModuleInfoSnapshotResolver(String name, YangParserFactory parserFactory) {
        this.ctxResolver = YangTextSchemaContextResolver.create((String)name, (YangParserFactory)parserFactory);
    }

    public synchronized <R extends DataRoot<R>> Registration registerModuleFeatures(Class<R> module, Set<? extends YangFeature<?, R>> supportedFeatures) {
        ImmutableSet features = (ImmutableSet)supportedFeatures.stream().map(YangFeature::qname).map(AbstractQName::getLocalName).sorted().collect(ImmutableSet.toImmutableSet());
        return this.ctxResolver.registerSupportedFeatures(BindingReflections.getQNameModule(module), (Set)features);
    }

    public synchronized List<Registration> registerModuleInfos(Iterable<? extends YangModuleInfo> moduleInfos) {
        ArrayList<Registration> ret = new ArrayList<Registration>();
        for (YangModuleInfo yangModuleInfo : moduleInfos) {
            ret.add(this.register(Objects.requireNonNull(yangModuleInfo)));
        }
        return ret;
    }

    @Holding(value={"this"})
    private Registration register(@NonNull YangModuleInfo moduleInfo) {
        final ImmutableList regInfos = (ImmutableList)ModuleInfoSnapshotResolver.flatDependencies(moduleInfo).stream().map(this::registerModuleInfo).collect(ImmutableList.toImmutableList());
        return new AbstractRegistration(){

            protected void removeRegistration() {
                ModuleInfoSnapshotResolver.this.unregister((List<RegisteredModuleInfo>)regInfos);
            }
        };
    }

    @Holding(value={"this"})
    private RegisteredModuleInfo registerModuleInfo(@NonNull YangModuleInfo info) {
        Registration reg;
        SourceIdentifier sourceId = ModuleInfoSnapshotResolver.sourceIdentifierFrom(info);
        for (RegisteredModuleInfo reg2 : this.sourceToInfoReg.get((Object)sourceId)) {
            if (!info.equals((Object)reg2.info)) continue;
            reg2.incRef();
            LOG.debug("Reusing registration {}", (Object)reg2);
            return reg2;
        }
        try {
            reg = this.ctxResolver.registerSource(ModuleInfoSnapshotResolver.toYangTextSource(sourceId, info));
        }
        catch (IOException | SchemaSourceException | YangSyntaxErrorException e) {
            throw new IllegalStateException("Failed to register info " + String.valueOf(info), e);
        }
        RegisteredModuleInfo regInfo = new RegisteredModuleInfo(info, reg, info.getClass().getClassLoader());
        LOG.debug("Created new registration {}", (Object)regInfo);
        this.sourceToInfoReg.put((Object)sourceId, (Object)regInfo);
        return regInfo;
    }

    public synchronized @NonNull ModuleInfoSnapshot takeSnapshot() {
        EffectiveModelContext effectiveModel = (EffectiveModelContext)this.ctxResolver.getEffectiveModelContext().orElseThrow();
        ModuleInfoSnapshot local = this.currentSnapshot;
        if (local != null && local.modelContext().equals((Object)effectiveModel)) {
            return local;
        }
        return this.updateSnapshot(effectiveModel);
    }

    @Holding(value={"this"})
    private @NonNull ModuleInfoSnapshot updateSnapshot(EffectiveModelContext modelContext) {
        HashSet<SourceIdentifier> sources = new HashSet<SourceIdentifier>();
        for (Map.Entry entry : modelContext.getModuleStatements().entrySet()) {
            Revision revision = ((QNameModule)entry.getKey()).revision();
            ModuleEffectiveStatement module = (ModuleEffectiveStatement)entry.getValue();
            sources.add(new SourceIdentifier((UnresolvedQName.Unqualified)module.argument(), revision));
            module.streamEffectiveSubstatements(SubmoduleEffectiveStatement.class).map(submodule -> new SourceIdentifier((UnresolvedQName.Unqualified)submodule.argument(), revision)).forEach(sources::add);
        }
        HashMap<SourceIdentifier, YangModuleInfo> moduleInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        for (SourceIdentifier source : sources) {
            List regs = this.sourceToInfoReg.get((Object)source);
            Preconditions.checkState((!regs.isEmpty() ? 1 : 0) != 0, (String)"No registration for %s", (Object)source);
            RegisteredModuleInfo reg = (RegisteredModuleInfo)regs.getFirst();
            YangModuleInfo info = reg.info;
            moduleInfos.put(source, info);
            classLoaders.put(Naming.getRootPackageName((QNameModule)info.getName().getModule()), info.getClass().getClassLoader());
        }
        DefaultModuleInfoSnapshot next = new DefaultModuleInfoSnapshot(modelContext, moduleInfos, classLoaders);
        this.currentSnapshot = next;
        return next;
    }

    private synchronized void unregister(List<RegisteredModuleInfo> regInfos) {
        for (RegisteredModuleInfo regInfo : regInfos) {
            if (!regInfo.decRef()) {
                LOG.debug("Registration {} has references, not removing it", (Object)regInfo);
                continue;
            }
            SourceIdentifier sourceId = ModuleInfoSnapshotResolver.sourceIdentifierFrom(regInfo.info);
            if (!this.sourceToInfoReg.remove((Object)sourceId, (Object)regInfo)) {
                LOG.warn("Failed to find {} registered under {}", (Object)regInfo, (Object)sourceId);
            }
            regInfo.reg.close();
        }
    }

    static @NonNull YangTextSource toYangTextSource(YangModuleInfo moduleInfo) {
        return new DelegatedYangTextSource(ModuleInfoSnapshotResolver.sourceIdentifierFrom(moduleInfo), moduleInfo.getYangTextCharSource());
    }

    private static @NonNull YangTextSource toYangTextSource(SourceIdentifier identifier, YangModuleInfo moduleInfo) {
        return new DelegatedYangTextSource(identifier, moduleInfo.getYangTextCharSource());
    }

    private static SourceIdentifier sourceIdentifierFrom(YangModuleInfo moduleInfo) {
        QName name = moduleInfo.getName();
        return new SourceIdentifier(name.getLocalName(), (Revision)name.getRevision().orElse(null));
    }

    private static @NonNull List<@NonNull YangModuleInfo> flatDependencies(YangModuleInfo moduleInfo) {
        LinkedHashSet<YangModuleInfo> requiredInfos = new LinkedHashSet<YangModuleInfo>();
        ModuleInfoSnapshotResolver.flatDependencies(requiredInfos, moduleInfo);
        return ImmutableList.copyOf(requiredInfos).reverse();
    }

    static void flatDependencies(Set<YangModuleInfo> set, YangModuleInfo moduleInfo) {
        if (set.add(moduleInfo)) {
            for (YangModuleInfo dep : moduleInfo.getImportedModules()) {
                ModuleInfoSnapshotResolver.flatDependencies(set, dep);
            }
        }
    }

    private static final class RegisteredModuleInfo {
        final Registration reg;
        final YangModuleInfo info;
        final ClassLoader loader;
        private int refcount = 1;

        RegisteredModuleInfo(YangModuleInfo info, Registration reg, ClassLoader loader) {
            this.info = Objects.requireNonNull(info);
            this.reg = Objects.requireNonNull(reg);
            this.loader = Objects.requireNonNull(loader);
        }

        void incRef() {
            ++this.refcount;
        }

        boolean decRef() {
            return --this.refcount == 0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("info", (Object)this.info).add("registration", (Object)this.reg).add("classLoader", (Object)this.loader).add("refCount", this.refcount).toString();
        }
    }
}

