/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.binding.model.api.AbstractType;
import org.opendaylight.yangtools.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.Enumeration;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.TypeComment;
import org.opendaylight.yangtools.binding.model.api.YangSourceDefinition;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.ConstantImpl;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.MethodSignatureBuilderImpl;
import org.opendaylight.yangtools.util.LazyCollections;

abstract class AbstractGeneratedTypeBuilder<T extends GeneratedTypeBuilderBase<T>>
extends AbstractType
implements GeneratedTypeBuilderBase<T> {
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private List<Type> implementsTypes = Collections.emptyList();
    private List<Enumeration> enumDefinitions = Collections.emptyList();
    private List<Constant> constants = Collections.emptyList();
    private List<MethodSignatureBuilder> methodDefinitions = Collections.emptyList();
    private List<GeneratedTransferObject> enclosedTransferObjects = Collections.emptyList();
    private List<GeneratedPropertyBuilder> properties = Collections.emptyList();
    private TypeComment comment;
    private boolean isAbstract;
    private YangSourceDefinition yangSourceDefinition;

    protected AbstractGeneratedTypeBuilder(JavaTypeName identifier) {
        super(identifier);
    }

    protected TypeComment getComment() {
        return this.comment;
    }

    protected List<AnnotationTypeBuilder> getAnnotations() {
        return this.annotationBuilders;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public List<Type> getImplementsTypes() {
        return this.implementsTypes;
    }

    protected List<Enumeration> getEnumerations() {
        return this.enumDefinitions;
    }

    protected List<Constant> getConstants() {
        return this.constants;
    }

    @Override
    public List<MethodSignatureBuilder> getMethodDefinitions() {
        return this.methodDefinitions;
    }

    protected List<GeneratedTransferObject> getEnclosedTransferObjects() {
        return this.enclosedTransferObjects;
    }

    protected abstract T thisInstance();

    @Override
    public T addEnclosingTransferObject(GeneratedTransferObject genTO) {
        Preconditions.checkArgument((genTO != null ? 1 : 0) != 0, (Object)"Parameter genTO cannot be null!");
        Preconditions.checkArgument((!this.enclosedTransferObjects.contains(genTO) ? 1 : 0) != 0, (Object)"This generated type already contains equal enclosing transfer object.");
        this.enclosedTransferObjects = LazyCollections.lazyAdd(this.enclosedTransferObjects, (Object)genTO);
        return this.thisInstance();
    }

    @Override
    public T addComment(TypeComment newComment) {
        this.comment = Objects.requireNonNull(newComment);
        return this.thisInstance();
    }

    @Override
    public AnnotationTypeBuilder addAnnotation(JavaTypeName identifier) {
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(identifier);
        Preconditions.checkArgument((!this.annotationBuilders.contains(builder) ? 1 : 0) != 0, (Object)"This generated type already contains equal annotation.");
        this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
        return builder;
    }

    @Override
    public T setAbstract(boolean newIsAbstract) {
        this.isAbstract = newIsAbstract;
        return this.thisInstance();
    }

    @Override
    public T addImplementsType(Type genType) {
        Preconditions.checkArgument((genType != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkArgument((!this.implementsTypes.contains(genType) ? 1 : 0) != 0, (Object)"This generated type already contains equal implements type.");
        this.implementsTypes = LazyCollections.lazyAdd(this.implementsTypes, (Object)genType);
        return this.thisInstance();
    }

    @Override
    public Constant addConstant(Type type, String name, Object value) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Returning Type for Constant cannot be null!");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of constant cannot be null!");
        Preconditions.checkArgument((!this.containsConstant(name) ? 1 : 0) != 0, (String)"This generated type already contains a \"%s\" constant", (Object)name);
        ConstantImpl constant = new ConstantImpl(type, name, value);
        this.constants = LazyCollections.lazyAdd(this.constants, (Object)constant);
        return constant;
    }

    public boolean containsConstant(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (Constant constant : this.constants) {
            if (!name.equals(constant.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addEnumeration(Enumeration enumeration) {
        Preconditions.checkArgument((enumeration != null ? 1 : 0) != 0, (Object)"Enumeration cannot be null!");
        Preconditions.checkArgument((!this.enumDefinitions.contains(enumeration) ? 1 : 0) != 0, (String)"Generated type %s already contains an enumeration for %s", (Object)this, (Object)enumeration);
        this.enumDefinitions = LazyCollections.lazyAdd(this.enumDefinitions, (Object)enumeration);
    }

    @Override
    public MethodSignatureBuilder addMethod(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of method cannot be null!");
        MethodSignatureBuilderImpl builder = new MethodSignatureBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        builder.setAbstract(true);
        this.methodDefinitions = LazyCollections.lazyAdd(this.methodDefinitions, (Object)builder);
        return builder;
    }

    @Override
    public boolean containsMethod(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (MethodSignatureBuilder methodDefinition : this.methodDefinitions) {
            if (!name.equals(methodDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeneratedPropertyBuilder addProperty(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        Preconditions.checkArgument((!this.containsProperty(name) ? 1 : 0) != 0, (Object)"This generated type already contains property with the same name.");
        GeneratedPropertyBuilderImpl builder = new GeneratedPropertyBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        this.properties = LazyCollections.lazyAdd(this.properties, (Object)builder);
        return builder;
    }

    @Override
    public boolean containsProperty(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (GeneratedPropertyBuilder property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    public Type getParent() {
        return null;
    }

    @Override
    public List<GeneratedPropertyBuilder> getProperties() {
        return this.properties;
    }

    @Override
    public Optional<YangSourceDefinition> getYangSourceDefinition() {
        return Optional.ofNullable(this.yangSourceDefinition);
    }

    @Override
    public void setYangSourceDefinition(YangSourceDefinition definition) {
        this.yangSourceDefinition = Objects.requireNonNull(definition);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).omitNullValues().add("comment", this.comment == null ? null : this.comment.getJavadoc()).add("constants", this.constants).add("enumerations", this.enumDefinitions).add("methods", this.methodDefinitions).add("annotations", this.annotationBuilders).add("implements", this.implementsTypes);
    }
}

