/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.TypeMemberComment;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.AbstractTypeMember;

class MethodSignatureImpl
extends AbstractTypeMember
implements MethodSignature {
    private final List<MethodSignature.Parameter> params;
    private final @NonNull MethodSignature.ValueMechanics mechanics;
    private final boolean isAbstract;
    private final boolean isDefault;

    @VisibleForTesting
    MethodSignatureImpl(String name, List<AnnotationType> annotations, TypeMemberComment comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic) {
        this(name, annotations, comment, accessModifier, returnType, params, isFinal, isAbstract, isStatic, false, MethodSignature.ValueMechanics.NORMAL);
    }

    MethodSignatureImpl(String name, List<AnnotationType> annotations, TypeMemberComment comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic, boolean isDefault, MethodSignature.ValueMechanics mechanics) {
        super(name, annotations, comment, accessModifier, returnType, isFinal, isStatic);
        this.params = params;
        this.isAbstract = isAbstract;
        this.isDefault = isDefault;
        this.mechanics = Objects.requireNonNull(mechanics);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public List<MethodSignature.Parameter> getParameters() {
        return this.params;
    }

    @Override
    public MethodSignature.ValueMechanics getMechanics() {
        return this.mechanics;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Objects.hashCode(this.getReturnType());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureImpl other = (MethodSignatureImpl)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.params, other.params) && Objects.equals(this.getReturnType(), other.getReturnType());
    }

    @Override
    public String toString() {
        return "MethodSignatureImpl [name=" + this.getName() + ", comment=" + this.getComment() + ", returnType=" + this.getReturnType() + ", params=" + this.params + ", annotations=" + this.getAnnotations() + ']';
    }
}

