/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.deployer.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.ops4j.pax.web.deployer.internal.DeployerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarDeployer
implements ArtifactUrlTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(WarDeployer.class);
    private static final String PATH_SEPERATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File artifact) {
        ZipFile jar = null;
        try {
            if (!artifact.getName().endsWith(".war") && !artifact.getName().endsWith(".war.jar")) {
                boolean bl = false;
                return bl;
            }
            jar = new JarFile(artifact);
            JarEntry entry = ((JarFile)jar).getJarEntry("WEB-INF/web.xml");
            if (entry == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No WAR archive, will not handle artifact: " + artifact.getName());
                }
                boolean e = false;
                return e;
            }
            Manifest m = ((JarFile)jar).getManifest();
            if (m != null && m.getMainAttributes().getValue("Bundle-SymbolicName") != null && m.getMainAttributes().getValue("Bundle-Version") != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("This artifact has OSGi Manifest Header skipping: " + artifact.getName());
                }
                boolean e = false;
                return e;
            }
        }
        catch (Exception e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Can't handle file " + artifact.getName(), (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block29: {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block29;
                        LOG.debug("Failed to close WAR file", (Throwable)e);
                    }
                }
            }
        }
        try {
            new URL("webbundle", null, artifact.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            LOG.warn("File {} could not be transformed. Most probably that Pax URL WAR handler is not installed", (Object)artifact.getAbsolutePath());
            return false;
        }
        return true;
    }

    public URL transform(URL artifact) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transforming artifact with URL: " + artifact);
        }
        String path = artifact.getPath();
        String protocol = artifact.getProtocol();
        if (path != null) {
            int idx;
            if ("jardir".equalsIgnoreCase(protocol)) {
                File fileInstance = new File(path);
                idx = fileInstance.getAbsolutePath().lastIndexOf(File.separator);
            } else {
                idx = path.lastIndexOf(PATH_SEPERATOR);
            }
            if (idx > 0) {
                String[] name = DeployerUtils.extractNameVersionType(path.substring(idx + 1));
                StringBuilder url = new StringBuilder();
                url.append(artifact.toExternalForm());
                if (artifact.toExternalForm().contains("?")) {
                    url.append("&");
                } else {
                    url.append("?");
                }
                url.append("Web-ContextPath=").append(name[0]);
                url.append("&");
                url.append("Bundle-SymbolicName=").append(name[0]);
                url.append("&");
                url.append("Bundle-Version=").append(name[1]);
                LOG.debug("Transformed URL of {} to following {}", (Object)path, (Object)url);
                return new URL("webbundle", null, url.toString());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No path for given artifact, retry with webbundle prepended");
        }
        return new URL("webbundle", null, artifact.toExternalForm());
    }
}

