/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;

@NonNullByDefault
abstract class AbstractDataTreeTip
implements DataTreeTip {
    AbstractDataTreeTip() {
    }

    abstract TreeNode getTipRoot();

    abstract YangInstanceIdentifier getRootPath();

    public final void validate(DataTreeModification modification) throws DataValidationFailedException {
        InMemoryDataTreeModification mod = AbstractDataTreeTip.accessMod(modification);
        try {
            mod.validate(this.getRootPath(), this.getTipRoot());
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public final DataTreeCandidateTip prepare(DataTreeModification modification) {
        InMemoryDataTreeModification mod = AbstractDataTreeTip.accessMod(modification);
        try {
            return mod.prepare(this.getRootPath(), this.getTipRoot());
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static InMemoryDataTreeModification accessMod(DataTreeModification mod) {
        if (mod instanceof InMemoryDataTreeModification) {
            InMemoryDataTreeModification inMemoryMod = (InMemoryDataTreeModification)mod;
            return inMemoryMod;
        }
        throw new IllegalArgumentException("Invalid modification " + String.valueOf(mod.getClass()));
    }
}

