/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.tree.api.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.api.ModifiedNodeDoesNotExistException;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.ChoiceModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.LeafSetModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.MapModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract sealed class AbstractNodeContainerModificationStrategy<T extends DataSchemaNode>
extends SchemaAwareApplyOperation<T> {
    private static final Version FAKE_VERSION = Version.initial(false);
    private final NormalizedNodeContainerSupport<?, ?> support;
    private final boolean verifyChildrenStructure;

    AbstractNodeContainerModificationStrategy(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig) {
        this.support = Objects.requireNonNull(support);
        this.verifyChildrenStructure = treeConfig.getTreeType() == TreeType.CONFIGURATION;
    }

    @Override
    protected final ChildTrackingPolicy getChildPolicy() {
        return this.support.childPolicy;
    }

    @Override
    final void verifyValue(NormalizedNode writtenValue) {
        Class nodeClass = this.support.requiredClass;
        Preconditions.checkArgument((boolean)nodeClass.isInstance(writtenValue), (String)"Node %s is not of type %s", (Object)writtenValue, nodeClass);
        Preconditions.checkArgument((boolean)(writtenValue instanceof NormalizedNodeContainer));
    }

    @Override
    final void verifyValueChildren(NormalizedNode writtenValue) {
        DistinctNodeContainer container = (DistinctNodeContainer)writtenValue;
        if (this.verifyChildrenStructure) {
            for (NormalizedNode child : container.body()) {
                ModificationApplyOperation childOp = this.childByArg(child.name());
                if (childOp == null) {
                    throw new SchemaValidationFailedException(String.format("Node %s is not a valid child of %s according to the schema.", child.name(), container.name()));
                }
                childOp.fullVerifyStructure(child);
            }
            this.optionalVerifyValueChildren(container);
        }
        this.mandatoryVerifyValueChildren(container);
    }

    void optionalVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
    }

    void mandatoryVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
    }

    @Override
    protected final void recursivelyVerifyStructure(NormalizedNode value) {
        NormalizedNodeContainer container = (NormalizedNodeContainer)value;
        for (NormalizedNode child : container.body()) {
            ModificationApplyOperation childOp = this.childByArg(child.name());
            if (childOp == null) {
                throw new SchemaValidationFailedException(String.format("Node %s is not a valid child of %s according to the schema.", child.name(), container.name()));
            }
            childOp.recursivelyVerifyStructure(child);
        }
    }

    @Override
    protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, TreeNode currentMeta, Version version) {
        TreeNode newValueMeta = TreeNode.of(newValue, version);
        if (modification.isEmpty()) {
            return newValueMeta;
        }
        TreeNode result = this.mutateChildren(newValueMeta.toMutable(version), this.support.createBuilder(newValue), version, modification.getChildren());
        return TreeNode.of(result.data(), version);
    }

    private TreeNode mutateChildren(MutableTreeNode meta, NormalizedNodeContainerBuilder data, Version nodeVersion, Iterable<ModifiedNode> modifications) {
        for (ModifiedNode mod : modifications) {
            YangInstanceIdentifier.PathArgument id = mod.getIdentifier();
            TreeNode result = this.resolveChildOperation(id).apply(mod, (TreeNode)meta.childByArg(id), nodeVersion);
            if (result != null) {
                meta.putChild(result);
                data.addChild(result.data());
                continue;
            }
            meta.removeChild(id);
            data.removeChild(id);
        }
        meta.setData(data.build());
        return meta.seal();
    }

    @Override
    protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
        NormalizedNode value = modification.getValue();
        if (!(value instanceof DistinctNodeContainer)) {
            throw new VerifyException("Attempted to merge non-container " + String.valueOf(value));
        }
        DistinctNodeContainer containerValue = (DistinctNodeContainer)value;
        Iterator it = containerValue.body().iterator();
        NormalizedNode first = AbstractNodeContainerModificationStrategy.nextToExpand(modification, it);
        return first == null ? this.applyTouch(modification, currentMeta, version) : this.applyMerge(modification, currentMeta, version, first, it);
    }

    @NonNullByDefault
    private TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version, NormalizedNode first, Iterator<? extends NormalizedNode> it) {
        ArrayList<ModifiedNode> expanded = new ArrayList<ModifiedNode>();
        ModifiedNode copy = new ModifiedNode(modification, this.getChildPolicy());
        NormalizedNode child = first;
        do {
            expanded.add(copy.createMergeChild(child, this.resolveChildOperation(child.name()), version));
        } while ((child = AbstractNodeContainerModificationStrategy.nextToExpand(copy, it)) != null);
        TreeNode ret = this.applyTouch(copy, currentMeta, version);
        modification.resolveModificationType(copy, expanded);
        return ret;
    }

    private static @Nullable NormalizedNode nextToExpand(ModifiedNode parent, Iterator<? extends NormalizedNode> it) {
        while (it.hasNext()) {
            NormalizedNode child = it.next();
            if (parent.childByArg(child.name()) != null) continue;
            return child;
        }
        return null;
    }

    private void mergeChildrenIntoModification(ModifiedNode modification, Collection<? extends NormalizedNode> children, Version version) {
        for (NormalizedNode normalizedNode : children) {
            ModificationApplyOperation childOp = this.resolveChildOperation(normalizedNode.name());
            ModifiedNode childNode = modification.modifyChild(normalizedNode.name(), childOp, version);
            childOp.mergeIntoModifiedNode(childNode, normalizedNode, version);
        }
    }

    @Override
    final void mergeIntoModifiedNode(ModifiedNode modification, NormalizedNode value, Version version) {
        Collection valueChildren = ((DistinctNodeContainer)value).body();
        LogicalOperation op = modification.getOperation();
        switch (op) {
            case NONE: {
                this.recursivelyVerifyStructure(value);
                modification.updateValue(LogicalOperation.MERGE, value);
                break;
            }
            case TOUCH: {
                this.mergeChildrenIntoModification(modification, valueChildren, version);
                modification.updateValue(LogicalOperation.MERGE, this.support.createEmptyValue(value));
                break;
            }
            case MERGE: {
                this.mergeChildrenIntoModification(modification, valueChildren, version);
                modification.updateOperationType(LogicalOperation.MERGE);
                break;
            }
            case DELETE: {
                TreeNode current;
                if (!modification.isEmpty() && (current = this.apply(modification, modification.original(), Version.initial(false))) != null) {
                    modification.updateValue(LogicalOperation.WRITE, current.data());
                    this.mergeChildrenIntoModification(modification, valueChildren, version);
                    return;
                }
                modification.updateValue(LogicalOperation.WRITE, value);
                break;
            }
            case WRITE: {
                this.mergeChildrenIntoModification(modification, valueChildren, version);
                modification.updateOperationType(LogicalOperation.WRITE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + String.valueOf((Object)op));
            }
        }
    }

    @Override
    protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
        if (!modification.isEmpty()) {
            NormalizedNodeContainerBuilder<?, ?, ?, ?> dataBuilder = this.support.createBuilder(currentMeta.data());
            Collection<ModifiedNode> children = modification.getChildren();
            TreeNode ret = this.mutateChildren(currentMeta.toMutable(version), dataBuilder, version, children);
            for (ModifiedNode child : children) {
                if (child.getModificationType() == ModificationType.UNMODIFIED) continue;
                modification.resolveModificationType(ModificationType.SUBTREE_MODIFIED);
                return ret;
            }
        }
        modification.resolveModificationType(ModificationType.UNMODIFIED);
        return currentMeta;
    }

    @Override
    protected final void checkTouchApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        TreeNode currentNode;
        if (currentMeta == null) {
            currentNode = this.defaultTreeNode();
            if (currentNode == null) {
                if (modification.original() == null) {
                    YangInstanceIdentifier id = path.toInstanceIdentifier();
                    throw new ModifiedNodeDoesNotExistException(id, "Node " + String.valueOf(id) + " does not exist. Cannot apply modification to its children.");
                }
                throw new ConflictingModificationAppliedException(path.toInstanceIdentifier(), "Node was deleted by other transaction.");
            }
        } else {
            currentNode = currentMeta;
        }
        this.checkChildPreconditions(path, modification, currentNode, version);
    }

    @Nullable TreeNode defaultTreeNode() {
        return null;
    }

    static final TreeNode defaultTreeNode(NormalizedNode emptyNode) {
        return TreeNode.of(emptyNode, FAKE_VERSION);
    }

    @Override
    protected final void checkMergeApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        if (currentMeta != null) {
            this.checkChildPreconditions(path, modification, currentMeta, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChildPreconditions(ModificationPath path, NodeModification modification, @NonNull TreeNode currentMeta, Version version) throws DataValidationFailedException {
        for (NodeModification nodeModification : modification.getChildren()) {
            YangInstanceIdentifier.PathArgument childId = (YangInstanceIdentifier.PathArgument)nodeModification.getIdentifier();
            TreeNode childMeta = (TreeNode)currentMeta.childByArg(childId);
            path.push(childId);
            try {
                this.resolveChildOperation(childId).checkApplicable(path, nodeModification, childMeta, version);
            }
            finally {
                path.pop();
            }
        }
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("support", this.support).add("verifyChildren", this.verifyChildrenStructure);
    }

    static abstract sealed class Visible<T extends DataSchemaNode>
    extends AbstractNodeContainerModificationStrategy<T>
    permits ChoiceModificationStrategy, DataNodeContainerModificationStrategy {
        private final @NonNull T schema;

        Visible(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig, T schema) {
            super(support, treeConfig);
            this.schema = (DataSchemaNode)Objects.requireNonNull(schema);
        }

        @Override
        final T getSchema() {
            return this.schema;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("schema", this.schema);
        }
    }

    static abstract sealed class Invisible<T extends DataSchemaNode>
    extends AbstractNodeContainerModificationStrategy<T>
    permits LeafSetModificationStrategy, MapModificationStrategy {
        private final @NonNull SchemaAwareApplyOperation<T> entryStrategy;

        Invisible(NormalizedNodeContainerSupport<?, ?> support, DataTreeConfiguration treeConfig, SchemaAwareApplyOperation<T> entryStrategy) {
            super(support, treeConfig);
            this.entryStrategy = Objects.requireNonNull(entryStrategy);
        }

        @Override
        final T getSchema() {
            return this.entryStrategy.getSchema();
        }

        final @NonNull ModificationApplyOperation entryStrategy() {
            return this.entryStrategy;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("entry", this.entryStrategy);
        }
    }
}

