/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;

final class BinaryValue
implements Immutable {
    private final byte[] value;

    private BinaryValue(byte[] value) {
        this.value = Objects.requireNonNull(value);
    }

    static Object wrap(Object value) {
        Object object;
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            object = new BinaryValue(bytes);
        } else {
            object = value;
        }
        return object;
    }

    static Object wrapToString(Object value) {
        Object object;
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            object = BinaryValue.toString(bytes);
        } else {
            object = value;
        }
        return object;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof BinaryValue)) return false;
        BinaryValue other = (BinaryValue)obj;
        if (!Arrays.equals(this.value, other.value)) return false;
        return true;
    }

    public String toString() {
        return BinaryValue.toString(this.value);
    }

    private static String toString(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }
}

