/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNodes;
import org.opendaylight.yangtools.yang.data.tree.api.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.VersionInfo;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursorAware;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractReadyIterator;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.NoopDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.OperationWithModification;
import org.opendaylight.yangtools.yang.data.tree.impl.RootApplyStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDataTreeModification
extends AbstractCursorAware
implements CursorAwareDataTreeModification {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTreeModification.class);
    private static final VarHandle STATE;
    private final RootApplyStrategy strategyTree;
    private final InMemoryDataTreeSnapshot snapshot;
    private final Version version;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile State state;

    private InMemoryDataTreeModification(RootApplyStrategy strategyTree, InMemoryDataTreeSnapshot snapshot) {
        this.strategyTree = Objects.requireNonNull(strategyTree);
        this.snapshot = Objects.requireNonNull(snapshot);
        TreeNode snapshotRoot = this.snapshotRoot();
        this.version = snapshotRoot.subtreeVersion().next();
        this.state = new Open(new ModifiedNode(snapshot.getRootNode(), this.getStrategy().getChildPolicy()));
    }

    @NonNullByDefault
    InMemoryDataTreeModification(InMemoryDataTreeSnapshot snapshot, RootApplyStrategy resolver) {
        this(resolver.snapshot(), snapshot);
    }

    ModificationApplyOperation getStrategy() {
        ModificationApplyOperation ret = this.strategyTree.delegate();
        if (ret == null) {
            throw new IllegalStateException("Schema Context is not available.");
        }
        return ret;
    }

    public EffectiveModelContext modelContext() {
        return this.snapshot.modelContext();
    }

    public void write(YangInstanceIdentifier path, NormalizedNode data) {
        ModifiedNode rootNode = this.checkOpen();
        InMemoryDataTreeModification.checkIdentifierReferencesData(rootNode, path, data);
        this.resolveModificationFor(rootNode, path).write(data);
    }

    public void merge(YangInstanceIdentifier path, NormalizedNode data) {
        ModifiedNode rootNode = this.checkOpen();
        InMemoryDataTreeModification.checkIdentifierReferencesData(rootNode, path, data);
        this.resolveModificationFor(rootNode, path).merge(data, this.version);
    }

    public void delete(YangInstanceIdentifier path) {
        this.resolveModificationFor(this.checkOpen(), path).delete();
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier path) {
        Map.Entry<TreeNode, YangInstanceIdentifier> tree = this.resolveSnapshot(path);
        return tree == null ? Optional.empty() : NormalizedNodes.findNode((YangInstanceIdentifier)tree.getValue(), (NormalizedNode)tree.getKey().data(), (YangInstanceIdentifier)path);
    }

    public Optional<VersionInfo> readVersionInfo(YangInstanceIdentifier path) {
        Map.Entry<TreeNode, YangInstanceIdentifier> tree = this.resolveSnapshot(path);
        return tree == null ? Optional.empty() : StoreTreeNodes.findNode((StoreTreeNode)tree.getKey(), (YangInstanceIdentifier)((YangInstanceIdentifier)path.relativeTo(tree.getValue()).orElseThrow())).flatMap(treeNode -> Optional.ofNullable(treeNode.subtreeVersion().readInfo()));
    }

    private @Nullable Map.Entry<TreeNode, YangInstanceIdentifier> resolveSnapshot(YangInstanceIdentifier path) {
        ModifiedNode rootNode;
        State local;
        State state = local = this.acquireState();
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noop.class, Open.class, Ready.class, AppliedToSnapshot.class, Prepared.class}, (Object)state2, n)) {
            case 0: {
                Noop noop = (Noop)state2;
                LOG.trace("No-op resolveSnapshot()");
                return Map.entry(this.snapshot.getRootNode(), YangInstanceIdentifier.of());
            }
            case 1: {
                Open open = (Open)state2;
                rootNode = open.root;
                break;
            }
            case 2: {
                Ready ready = (Ready)state2;
                rootNode = ready.root;
                break;
            }
            case 3: {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                rootNode = applied.root;
                break;
            }
            case 4: {
                Prepared prepared = (Prepared)state2;
                rootNode = prepared.root;
                break;
            }
            default: {
                throw InMemoryDataTreeModification.illegalState(local, "access data of");
            }
        }
        LOG.trace("Concurrent resolveSnapshot() in state {}", (Object)local);
        Map.Entry terminal = StoreTreeNodes.findClosestsOrFirstMatch((StoreTreeNode)rootNode, (YangInstanceIdentifier)path, node -> switch (node.getOperation()) {
            default -> throw new MatchException(null, null);
            case LogicalOperation.DELETE, LogicalOperation.MERGE, LogicalOperation.WRITE -> true;
            case LogicalOperation.NONE, LogicalOperation.TOUCH -> false;
        });
        YangInstanceIdentifier terminalPath = (YangInstanceIdentifier)terminal.getKey();
        TreeNode result = this.resolveSnapshot(terminalPath, (ModifiedNode)terminal.getValue());
        return result == null ? null : Map.entry(result, terminalPath);
    }

    private @Nullable TreeNode resolveSnapshot(YangInstanceIdentifier path, ModifiedNode modification) {
        Optional<TreeNode> potentialSnapshot = modification.getSnapshot();
        if (potentialSnapshot != null) {
            return potentialSnapshot.orElse(null);
        }
        try {
            return this.resolveModificationStrategy(path).apply(modification, modification.original(), this.version);
        }
        catch (Exception e) {
            LOG.error("Could not create snapshot for {}:{}", new Object[]{path, modification, e});
            throw e;
        }
    }

    void upgradeIfPossible() {
        State state = this.acquireState();
        if (state instanceof Open) {
            Open open = (Open)state;
            try {
                ModifiedNode modifiedNode;
                ModifiedNode rootNode = modifiedNode = open.root();
                this.upgradeIfPossible(rootNode);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    private void upgradeIfPossible(ModifiedNode rootNode) {
        if (rootNode.getOperation() == LogicalOperation.NONE) {
            this.strategyTree.upgradeIfPossible();
        }
    }

    private ModificationApplyOperation resolveModificationStrategy(YangInstanceIdentifier path) {
        LOG.trace("Resolving modification apply strategy for {}", (Object)path);
        this.upgradeIfPossible();
        return (ModificationApplyOperation)StoreTreeNodes.findNodeChecked((StoreTreeNode)this.getStrategy(), (YangInstanceIdentifier)path);
    }

    private OperationWithModification resolveModificationFor(ModifiedNode rootNode, YangInstanceIdentifier path) {
        this.upgradeIfPossible(rootNode);
        ModificationApplyOperation operation = this.getStrategy();
        ModifiedNode modification = rootNode;
        int depth = 1;
        for (YangInstanceIdentifier.PathArgument pathArg : path.getPathArguments()) {
            if ((operation = operation.childByArg(pathArg)) == null) {
                throw new SchemaValidationFailedException(String.format("Child %s is not present in schema tree.", path.getAncestor(depth)));
            }
            ++depth;
            modification = modification.modifyChild(pathArg, operation, this.version);
        }
        return OperationWithModification.from(operation, modification);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.acquireState()).toString();
    }

    public InMemoryDataTreeModification newModification() {
        State local;
        State state = local = this.acquireState();
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noop.class, AppliedToSnapshot.class, Prepared.class, Ready.class}, (Object)state2, n)) {
            case 0 -> {
                Noop noop = (Noop)state2;
                LOG.trace("No-op newModification()");
                yield this.snapshot.newModification();
            }
            case 1 -> {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                yield this.concurrentNewModification(applied, applied.applied);
            }
            case 2 -> {
                Prepared prepared = (Prepared)state2;
                yield this.concurrentNewModification(prepared, prepared.applied);
            }
            case 3 -> {
                Ready ready = (Ready)state2;
                yield this.lockedNewModification(ready);
            }
            default -> throw InMemoryDataTreeModification.illegalState(local, "chain on");
        };
    }

    @NonNullByDefault
    private InMemoryDataTreeModification newModification(TreeNode rootNode) {
        return new InMemoryDataTreeSnapshot(this.snapshot.modelContext(), rootNode, this.strategyTree).newModification();
    }

    @NonNullByDefault
    private InMemoryDataTreeModification concurrentNewModification(State observed, TreeNode rootNode) {
        LOG.trace("Concurrent newModification() in state {}", (Object)observed);
        return this.newModification(rootNode);
    }

    @NonNullByDefault
    private synchronized InMemoryDataTreeModification lockedNewModification(Ready prev) {
        State local = this.plainState();
        LOG.trace("Locked newModification() in state {}", (Object)local);
        State state = local;
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AppliedToSnapshot.class, Prepared.class, Ready.class}, (Object)state2, n)) {
            case 0 -> {
                AppliedToSnapshot ready = (AppliedToSnapshot)state2;
                yield this.newModification(ready.applied);
            }
            case 1 -> {
                Prepared prepared = (Prepared)state2;
                yield this.newModification(prepared.applied);
            }
            case 2 -> {
                Ready ready = (Ready)state2;
                TreeNode after = this.getStrategy().apply(ready.root, this.snapshotRoot(), this.version);
                if (after == null) {
                    throw new IllegalStateException("Data tree root is not present, possibly removed by previous modification");
                }
                STATE.set(this, new AppliedToSnapshot(ready.root, after));
                yield this.newModification(after);
            }
            default -> throw new VerifyException("Unexpected transition from " + String.valueOf(prev) + " to " + String.valueOf(local));
        };
    }

    Version getVersion() {
        return this.version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ModifiedNode checkOpen() {
        State local = this.acquireState();
        if (!(local instanceof Open)) throw new IllegalStateException("Data Tree is sealed. No further modifications allowed in state " + String.valueOf(local));
        Open open = (Open)local;
        try {
            ModifiedNode modifiedNode = open.root();
            return modifiedNode;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static void applyNode(DataTreeModificationCursor cursor, NodeModification node) {
        LogicalOperation operation = node.getOperation();
        switch (operation) {
            case NONE: {
                break;
            }
            case DELETE: {
                cursor.delete((YangInstanceIdentifier.PathArgument)node.getIdentifier());
                break;
            }
            case MERGE: {
                cursor.merge((YangInstanceIdentifier.PathArgument)node.getIdentifier(), node.getValue());
                InMemoryDataTreeModification.applyNodeChildren(cursor, node);
                break;
            }
            case TOUCH: {
                InMemoryDataTreeModification.applyNodeChildren(cursor, node);
                break;
            }
            case WRITE: {
                cursor.write((YangInstanceIdentifier.PathArgument)node.getIdentifier(), node.getValue());
                InMemoryDataTreeModification.applyNodeChildren(cursor, node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node operation " + String.valueOf((Object)operation));
            }
        }
    }

    private static void applyNodeChildren(DataTreeModificationCursor cursor, NodeModification node) {
        if (!node.isEmpty()) {
            cursor.enter((YangInstanceIdentifier.PathArgument)node.getIdentifier());
            InMemoryDataTreeModification.applyChildren(cursor, node);
            cursor.exit();
        }
    }

    private static void applyChildren(DataTreeModificationCursor cursor, NodeModification node) {
        for (NodeModification nodeModification : node.getChildren()) {
            InMemoryDataTreeModification.applyNode(cursor, nodeModification);
        }
    }

    public void applyToCursor(DataTreeModificationCursor cursor) {
        NodeModification rootNode;
        State local;
        State state = local = this.acquireState();
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noop.class, Open.class, Ready.class, AppliedToSnapshot.class, Defunct.class, Prepared.class}, (Object)state2, n)) {
            case 0: {
                Noop noop = (Noop)state2;
                LOG.trace("No-op applyToCursor()");
                return;
            }
            case 1: {
                Open open = (Open)state2;
                rootNode = open.root;
                break;
            }
            case 2: {
                Ready ready = (Ready)state2;
                rootNode = ready.root;
                break;
            }
            case 3: {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                rootNode = applied.root;
                break;
            }
            case 4: {
                Defunct defunct = (Defunct)state2;
                rootNode = defunct.root;
                break;
            }
            case 5: {
                Prepared prepared = (Prepared)state2;
                rootNode = prepared.root;
                break;
            }
            default: {
                throw InMemoryDataTreeModification.illegalState(local, "access contents of");
            }
        }
        LOG.trace("Concurrent applyToCursor() in state {}", (Object)local);
        InMemoryDataTreeModification.applyChildren(cursor, rootNode);
    }

    static void checkIdentifierReferencesData(YangInstanceIdentifier.PathArgument arg, NormalizedNode data) {
        YangInstanceIdentifier.PathArgument dataName = data.name();
        Preconditions.checkArgument((boolean)arg.equals((Object)dataName), (String)"Instance identifier references %s but data identifier is %s", (Object)arg, (Object)dataName);
    }

    private static void checkIdentifierReferencesData(ModifiedNode rootNode, YangInstanceIdentifier path, NormalizedNode data) {
        YangInstanceIdentifier.PathArgument arg = path.getLastPathArgument();
        if (arg == null) {
            arg = rootNode.getIdentifier();
        }
        InMemoryDataTreeModification.checkIdentifierReferencesData(arg, data);
    }

    public Optional<DataTreeModificationCursor> openCursor(YangInstanceIdentifier path) {
        OperationWithModification op = this.resolveModificationFor(this.checkOpen(), path);
        return Optional.of((DataTreeModificationCursor)this.openCursor(new InMemoryDataTreeModificationCursor(this, path, op)));
    }

    public void ready() {
        State local = this.acquireState();
        if (!(local instanceof Open)) {
            throw InMemoryDataTreeModification.illegalState(local, "ready");
        }
        Open open = (Open)local;
        State witness = STATE.compareAndExchange(this, open, Sealing.INSTANCE);
        if (witness != open) {
            throw new ConcurrentModificationException(String.valueOf(this) + " state changed from " + String.valueOf(open) + " to " + String.valueOf(witness));
        }
        LOG.trace("Ready operation started");
        this.ready(open.root);
    }

    @NonNullByDefault
    private void ready(ModifiedNode rootNode) {
        LogicalOperation rootOperation;
        try {
            rootOperation = this.runReady(rootNode);
        }
        catch (Throwable t) {
            this.finishReady(new Defunct(rootNode, Thread.currentThread().getName(), t));
            throw t;
        }
        this.finishReady(rootOperation == LogicalOperation.NONE ? Noop.INSTANCE : new Ready(rootNode));
    }

    @VisibleForTesting
    @NonNullByDefault
    LogicalOperation runReady(ModifiedNode rootNode) {
        AbstractReadyIterator current = AbstractReadyIterator.create(rootNode, this.getStrategy());
        while ((current = current.process(this.version)) != null) {
        }
        return rootNode.getOperation();
    }

    @NonNullByDefault
    private void finishReady(State nextState) {
        STATE.setRelease(this, nextState);
        LOG.trace("Ready operation completed in state {}", (Object)nextState);
    }

    @NonNullByDefault
    void validate(YangInstanceIdentifier path, TreeNode current) throws DataValidationFailedException {
        State local;
        State state = local = this.acquireState();
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noop.class, Prepared.class, Ready.class, AppliedToSnapshot.class}, (Object)state2, n)) {
            case 0: {
                Noop noop = (Noop)state2;
                LOG.trace("No-op validate()");
                break;
            }
            case 1: {
                Prepared prepared = (Prepared)state2;
                LOG.trace("Prepared validate()");
                break;
            }
            case 2: {
                Ready ready = (Ready)state2;
                this.lockedValidate(ready.root, path, current);
                break;
            }
            case 3: {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                LOG.trace("Concurrent validate()");
                this.validate(applied.root, path, current);
                break;
            }
            default: {
                throw InMemoryDataTreeModification.illegalState(local, "validate");
            }
        }
    }

    @NonNullByDefault
    private void validate(NodeModification rootNode, YangInstanceIdentifier path, TreeNode current) throws DataValidationFailedException {
        this.getStrategy().checkApplicable(new ModificationPath(path), rootNode, current, this.version);
    }

    @NonNullByDefault
    private synchronized void lockedValidate(NodeModification rootNode, YangInstanceIdentifier path, TreeNode current) throws DataValidationFailedException {
        LOG.trace("Locked validate()");
        this.validate(rootNode, path, current);
    }

    @NonNullByDefault
    DataTreeCandidateTip prepare(YangInstanceIdentifier path, TreeNode current) {
        State local;
        State state = local = this.acquireState();
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noop.class, Ready.class, AppliedToSnapshot.class, Prepared.class}, (Object)state2, n)) {
            case 0 -> {
                Noop noop = (Noop)state2;
                LOG.trace("No-op prepare()");
                yield new NoopDataTreeCandidate(YangInstanceIdentifier.of(), current);
            }
            case 1 -> {
                Ready ready = (Ready)state2;
                yield this.lockedPrepare(ready, path, current);
            }
            case 2 -> {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                yield this.concurrentPrepare(applied, applied.root, path, current);
            }
            case 3 -> {
                Prepared prepared = (Prepared)state2;
                yield this.concurrentPrepare(prepared, prepared.root, path, current);
            }
            default -> throw InMemoryDataTreeModification.illegalState(local, "prepare");
        };
    }

    @NonNullByDefault
    private Prepared prepare(ModifiedNode rootNode, YangInstanceIdentifier path, TreeNode current) {
        TreeNode newRoot = this.getStrategy().apply(rootNode, current, this.version);
        if (newRoot == null) {
            throw new IllegalStateException("Apply strategy failed to produce root node for modification " + String.valueOf(this));
        }
        return new Prepared(rootNode, newRoot);
    }

    @NonNullByDefault
    private DataTreeCandidateTip concurrentPrepare(State prev, ModifiedNode rootNode, YangInstanceIdentifier path, TreeNode current) {
        LOG.trace("Concurrent prepare() in state {}", (Object)prev);
        Prepared prepared = this.prepare(rootNode, path, current);
        Object witness = STATE.compareAndExchangeRelease(this, prev, prepared);
        if (witness != prev) {
            throw new ConcurrentModificationException(String.valueOf(this) + " changed state changed from " + String.valueOf(prev) + " to " + String.valueOf(witness));
        }
        return new InMemoryDataTreeCandidate(YangInstanceIdentifier.of(), rootNode, current, prepared.applied);
    }

    @NonNullByDefault
    private synchronized DataTreeCandidateTip lockedPrepare(Ready prev, YangInstanceIdentifier path, TreeNode current) {
        State local = this.plainState();
        LOG.trace("Locked prepare() in state {}", (Object)local);
        State state = local;
        Objects.requireNonNull(state);
        State state2 = state;
        int n = 0;
        ModifiedNode rootNode = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ready.class, AppliedToSnapshot.class, Prepared.class}, (Object)state2, n)) {
            case 0 -> {
                Ready ready = (Ready)state2;
                yield ready.root;
            }
            case 1 -> {
                AppliedToSnapshot applied = (AppliedToSnapshot)state2;
                yield applied.root;
            }
            case 2 -> {
                Prepared prepared = (Prepared)state2;
                throw new ConcurrentModificationException(String.valueOf(this) + " changed state changed from " + String.valueOf(prev) + " to " + String.valueOf(local));
            }
            default -> throw new VerifyException("Unexpected transition from " + String.valueOf(prev) + " to " + String.valueOf(local));
        };
        Prepared prepared = this.prepare(rootNode, path, current);
        STATE.set(this, prepared);
        return new InMemoryDataTreeCandidate(YangInstanceIdentifier.of(), rootNode, current, prepared.applied);
    }

    @VisibleForTesting
    @NonNullByDefault
    TreeNode snapshotRoot() {
        return this.snapshot.getRootNode();
    }

    @VisibleForTesting
    @NonNullByDefault
    State acquireState() {
        return (State)Verify.verifyNotNull((Object)STATE.getAcquire(this));
    }

    @NonNullByDefault
    private State plainState() {
        return (State)Verify.verifyNotNull((Object)STATE.get(this));
    }

    @NonNullByDefault
    private static IllegalStateException illegalState(State state, String operation) {
        Throwable throwable;
        String string = "Attempted to " + operation + " modification in state " + String.valueOf(state);
        if (state instanceof Defunct) {
            Defunct defunct = (Defunct)state;
            throwable = defunct.cause;
        } else {
            throwable = null;
        }
        throw new IllegalStateException(string, throwable);
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(InMemoryDataTreeModification.class, "state", State.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @NonNullByDefault
    private record Open(ModifiedNode root) implements State
    {
        Open {
            Objects.requireNonNull(root);
        }

        @Override
        public String toString() {
            return "Open";
        }
    }

    @VisibleForTesting
    static sealed interface State
    permits SingletonState, Open, Defunct, Ready, AppliedToSnapshot, Prepared {
    }

    @NonNullByDefault
    private static final class Noop
    extends SingletonState {
        static final Noop INSTANCE = new Noop();

        private Noop() {
        }
    }

    @NonNullByDefault
    private record Ready(ModifiedNode root) implements State
    {
        Ready {
            Objects.requireNonNull(root);
        }

        @Override
        public String toString() {
            return "Ready";
        }
    }

    @NonNullByDefault
    private record AppliedToSnapshot(ModifiedNode root, TreeNode applied) implements State
    {
        AppliedToSnapshot {
            Objects.requireNonNull(root);
            Objects.requireNonNull(applied);
        }

        @Override
        public String toString() {
            return "AppliedToSnapshot";
        }
    }

    @NonNullByDefault
    private record Prepared(ModifiedNode root, TreeNode applied) implements State
    {
        Prepared {
            Objects.requireNonNull(root);
            Objects.requireNonNull(applied);
        }

        @Override
        public String toString() {
            return "Prepared";
        }
    }

    private record Defunct(NodeModification root, String threadName, @NonNull Throwable cause) implements State
    {
        Defunct(NodeModification root, String threadName, @NonNull Throwable cause) {
            Objects.requireNonNull(root);
            Objects.requireNonNull(cause);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("threadName", (Object)this.threadName).add("cause", (Object)this.cause).toString();
        }
    }

    @NonNullByDefault
    private static final class Sealing
    extends SingletonState {
        static final Sealing INSTANCE = new Sealing();

        private Sealing() {
        }
    }

    private static abstract sealed class SingletonState
    implements State
    permits Sealing, Noop {
        private SingletonState() {
        }

        public final String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

