/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.tree.api.SchemaValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursor;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.OperationWithModification;

final class InMemoryDataTreeModificationCursor
extends AbstractCursor<InMemoryDataTreeModification>
implements DataTreeModificationCursor {
    private final Deque<OperationWithModification> stack = new ArrayDeque<OperationWithModification>();

    InMemoryDataTreeModificationCursor(InMemoryDataTreeModification parent, YangInstanceIdentifier rootPath, OperationWithModification rootOp) {
        super(parent, rootPath);
        this.stack.push(rootOp);
    }

    private OperationWithModification resolveChildModification(YangInstanceIdentifier.PathArgument child) {
        ((InMemoryDataTreeModification)this.getParent()).upgradeIfPossible();
        OperationWithModification op = this.stack.peek();
        ModificationApplyOperation operation = op.getApplyOperation().childByArg(child);
        if (operation != null) {
            return OperationWithModification.from(operation, op.getModification().modifyChild(child, operation, ((InMemoryDataTreeModification)this.getParent()).getVersion()));
        }
        ArrayList<YangInstanceIdentifier.PathArgument> path = new ArrayList<YangInstanceIdentifier.PathArgument>();
        path.addAll(this.getRootPath().getPathArguments());
        Iterator<OperationWithModification> it = this.stack.descendingIterator();
        it.next();
        while (it.hasNext()) {
            path.add(it.next().getModification().getIdentifier());
        }
        throw new SchemaValidationFailedException(String.format("Child %s is not present in schema tree.", path));
    }

    public void enter(YangInstanceIdentifier.PathArgument child) {
        this.stack.push(this.resolveChildModification(child));
    }

    public void enter(Iterable<YangInstanceIdentifier.PathArgument> path) {
        int depth = 0;
        for (YangInstanceIdentifier.PathArgument child : path) {
            try {
                this.stack.push(this.resolveChildModification(child));
            }
            catch (Exception e) {
                for (int i = 0; i < depth; ++i) {
                    this.stack.pop();
                }
                throw new IllegalArgumentException(e);
            }
            ++depth;
        }
    }

    public void exit(int depth) {
        Preconditions.checkArgument((depth >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((depth < this.stack.size() ? 1 : 0) != 0);
        for (int i = 0; i < depth; ++i) {
            this.stack.pop();
        }
    }

    public Optional<NormalizedNode> readNode(YangInstanceIdentifier.PathArgument child) {
        return this.stack.peek().read(child, ((InMemoryDataTreeModification)this.getParent()).getVersion());
    }

    public void delete(YangInstanceIdentifier.PathArgument child) {
        this.ensureNotClosed();
        this.resolveChildModification(child).delete();
    }

    public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
        this.ensureNotClosed();
        InMemoryDataTreeModification.checkIdentifierReferencesData(child, data);
        this.resolveChildModification(child).merge(data, ((InMemoryDataTreeModification)this.getParent()).getVersion());
    }

    public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
        this.ensureNotClosed();
        InMemoryDataTreeModification.checkIdentifierReferencesData(child, data);
        this.resolveChildModification(child).write(data);
    }
}

