/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.impl.ChildTrackingPolicy;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.ValidatedTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

final class ModifiedNode
extends NodeModification
implements StoreTreeNode<ModifiedNode> {
    private final @Nullable TreeNode original;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument identifier;
    private @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument, ModifiedNode> children;
    private @NonNull LogicalOperation operation;
    private NormalizedNode value;
    private TreeNode writtenOriginal;
    private Optional<TreeNode> snapshotCache;
    private ModificationType modType;
    private Map<YangInstanceIdentifier.PathArgument, ModifiedNode> applyChildren;
    private ModificationApplyOperation validatedOp;
    private @Nullable TreeNode validatedCurrent;
    private ValidatedTreeNode validatedNode;

    private ModifiedNode(YangInstanceIdentifier.PathArgument identifier, @Nullable TreeNode original, ChildTrackingPolicy childPolicy) {
        this.identifier = Objects.requireNonNull(identifier);
        this.original = original;
        this.children = childPolicy.createMap();
        this.operation = LogicalOperation.NONE;
    }

    ModifiedNode(ModifiedNode prev, ChildTrackingPolicy childPolicy) {
        this.identifier = prev.identifier;
        this.original = prev.original;
        this.children = childPolicy.createMap();
        this.operation = prev.operation;
        this.value = prev.value;
        this.writtenOriginal = prev.writtenOriginal;
        this.children.putAll(prev.children);
    }

    ModifiedNode(TreeNode metadataTree, ChildTrackingPolicy childPolicy) {
        this(metadataTree.data().name(), metadataTree, childPolicy);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    @Override
    LogicalOperation getOperation() {
        return this.operation;
    }

    @Override
    TreeNode original() {
        return this.original;
    }

    @Override
    NormalizedNode getValue() {
        return (NormalizedNode)Verify.verifyNotNull((Object)this.value);
    }

    public ModifiedNode childByArg(YangInstanceIdentifier.PathArgument arg) {
        return this.children.get(arg);
    }

    private @Nullable TreeNode metadataFromSnapshot(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child) {
        TreeNode local = this.original;
        return local != null ? (TreeNode)local.childByArg(child) : null;
    }

    private @Nullable TreeNode metadataFromData(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        if (this.writtenOriginal == null) {
            this.writtenOriginal = TreeNode.of(this.value, modVersion);
        }
        return (TreeNode)this.writtenOriginal.childByArg(child);
    }

    private @Nullable TreeNode originalMetadata(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.PathArgument child, Version modVersion) {
        return switch (this.operation) {
            default -> throw new MatchException(null, null);
            case LogicalOperation.DELETE -> null;
            case LogicalOperation.NONE, LogicalOperation.TOUCH, LogicalOperation.MERGE -> this.metadataFromSnapshot(child);
            case LogicalOperation.WRITE -> this.metadataFromData(child, modVersion);
        };
    }

    @NonNullByDefault
    ModifiedNode modifyChild(YangInstanceIdentifier.PathArgument child, ModificationApplyOperation childOper, Version modVersion) {
        NormalizedNode childData;
        ModifiedNode potential;
        this.clearSnapshot();
        if (this.operation == LogicalOperation.NONE) {
            this.updateOperationType(LogicalOperation.TOUCH);
        }
        if ((potential = this.children.get(child)) != null) {
            return potential;
        }
        ModifiedNode newlyCreated = new ModifiedNode(child, this.originalMetadata(child, modVersion), childOper.getChildPolicy());
        if (this.operation == LogicalOperation.MERGE && this.value != null && (childData = ((DistinctNodeContainer)this.value).childByArg(child)) != null) {
            childOper.mergeIntoModifiedNode(newlyCreated, childData, modVersion);
        }
        this.children.put(child, newlyCreated);
        return newlyCreated;
    }

    @NonNullByDefault
    ModifiedNode createMergeChild(NormalizedNode child, ModificationApplyOperation childOper, Version modVersion) {
        YangInstanceIdentifier.PathArgument name = child.name();
        ModifiedNode node = new ModifiedNode(name, this.originalMetadata(name, modVersion), childOper.getChildPolicy());
        childOper.mergeIntoModifiedNode(node, child, modVersion);
        ModifiedNode existing = this.children.putIfAbsent(name, node);
        if (existing != null) {
            throw new VerifyException("Attempted to replace " + String.valueOf(existing) + " with " + String.valueOf(node));
        }
        return node;
    }

    Collection<ModifiedNode> getChildren() {
        return this.children.values();
    }

    @Override
    boolean isEmpty() {
        return this.children.isEmpty();
    }

    void delete() {
        LogicalOperation newType = switch (this.operation) {
            default -> throw new MatchException(null, null);
            case LogicalOperation.DELETE, LogicalOperation.NONE -> LogicalOperation.DELETE;
            case LogicalOperation.MERGE -> LogicalOperation.DELETE;
            case LogicalOperation.TOUCH, LogicalOperation.WRITE -> this.original != null ? LogicalOperation.DELETE : LogicalOperation.NONE;
        };
        this.clearSnapshot();
        this.children.clear();
        this.value = null;
        this.updateOperationType(newType);
    }

    void write(NormalizedNode newValue) {
        this.updateValue(LogicalOperation.WRITE, newValue);
        this.children.clear();
    }

    void seal(ModificationApplyOperation schema, Version version) {
        this.clearSnapshot();
        this.writtenOriginal = null;
        boolean clearChildren = this.children.isEmpty();
        switch (this.operation) {
            case TOUCH: {
                if (!clearChildren) break;
                this.updateOperationType(LogicalOperation.NONE);
                break;
            }
            case WRITE: {
                if (!clearChildren) {
                    TreeNode applied = schema.apply(this, this.original(), version);
                    this.value = applied != null ? applied.data() : null;
                    clearChildren = true;
                }
                if (this.value == null) {
                    this.updateOperationType(LogicalOperation.DELETE);
                    break;
                }
                schema.fullVerifyStructure(this.value);
                break;
            }
        }
        if (clearChildren) {
            this.children = Map.of();
        }
    }

    private void clearSnapshot() {
        this.snapshotCache = null;
    }

    Optional<TreeNode> getSnapshot() {
        return this.snapshotCache;
    }

    @Nullable TreeNode setSnapshot(@Nullable TreeNode snapshot) {
        this.snapshotCache = Optional.ofNullable(snapshot);
        return snapshot;
    }

    void updateOperationType(LogicalOperation type) {
        this.operation = Objects.requireNonNull(type);
        this.modType = null;
        this.applyChildren = null;
        this.writtenOriginal = null;
        this.clearSnapshot();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", (Object)this.identifier).add("operation", (Object)this.operation).add("modificationType", (Object)this.modType);
        if (!this.children.isEmpty()) {
            helper.add("childModification", this.children);
        }
        return helper.toString();
    }

    void resolveModificationType(@NonNull ModificationType type) {
        this.modType = Objects.requireNonNull(type);
        this.applyChildren = ImmutableMap.of();
    }

    @NonNullByDefault
    void resolveModificationType(ModifiedNode source, List<ModifiedNode> extraChildren) {
        this.modType = source.modType;
        this.snapshotCache = source.snapshotCache;
        this.validatedOp = source.validatedOp;
        this.validatedCurrent = source.validatedCurrent;
        this.validatedNode = source.validatedNode;
        this.applyChildren = (Map)extraChildren.stream().filter(node -> node.getModificationType() != ModificationType.UNMODIFIED).collect(ImmutableMap.toImmutableMap(ModifiedNode::getIdentifier, Function.identity()));
    }

    void updateValue(LogicalOperation type, NormalizedNode newValue) {
        this.value = Objects.requireNonNull(newValue);
        this.updateOperationType(type);
    }

    ModificationType getModificationType() {
        return this.modType;
    }

    @Nullable ModifiedNode modifiedChild(YangInstanceIdentifier.PathArgument childName) {
        ModifiedNode child = this.children.get(childName);
        return child != null ? child : this.applyChildren.get(childName);
    }

    Collection<ModifiedNode> modifiedChildren() {
        final Collection<ModifiedNode> normal = this.getChildren();
        if (this.applyChildren.isEmpty()) {
            return normal;
        }
        final AbstractCollection<ModifiedNode> apply = this.applyChildren.values();
        return normal.isEmpty() ? apply : new AbstractCollection<ModifiedNode>(this){

            @Override
            public Iterator<ModifiedNode> iterator() {
                return Iterators.concat(normal.iterator(), apply.iterator());
            }

            @Override
            public int size() {
                return normal.size() + apply.size();
            }
        };
    }

    void setValidatedNode(ModificationApplyOperation op, @Nullable TreeNode currentMeta, @Nullable TreeNode node) {
        this.validatedOp = Objects.requireNonNull(op);
        this.validatedCurrent = currentMeta;
        this.validatedNode = new ValidatedTreeNode(node);
    }

    @Nullable ValidatedTreeNode validatedNode(ModificationApplyOperation op, @Nullable TreeNode storeMeta) {
        return op.equals(this.validatedOp) && Objects.equals(storeMeta, this.validatedCurrent) ? this.validatedNode : null;
    }
}

