/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.spi.node.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.api.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ChoiceModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ExcludedDataSchemaNodeException;
import org.opendaylight.yangtools.yang.data.tree.impl.LeafSetModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.ListModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.MapModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.MinMaxElementsValidation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NodeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.UniqueValidation;
import org.opendaylight.yangtools.yang.data.tree.impl.ValueNodeModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract sealed class SchemaAwareApplyOperation<T extends DataSchemaNode>
extends ModificationApplyOperation
permits AbstractNodeContainerModificationStrategy, ListModificationStrategy, ValueNodeModificationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaAwareApplyOperation.class);
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NormalizedNode.BuilderFactory BUILDER_FACTORY = ImmutableNodes.builderFactory();

    SchemaAwareApplyOperation() {
    }

    static ModificationApplyOperation from(DataSchemaNode schemaNode, DataTreeConfiguration treeConfig) throws ExcludedDataSchemaNodeException {
        if (!SchemaAwareApplyOperation.belongsToTree(treeConfig.getTreeType(), schemaNode)) {
            throw new ExcludedDataSchemaNodeException(String.valueOf(schemaNode) + " does not belong to configuration tree");
        }
        DataSchemaNode dataSchemaNode = schemaNode;
        Objects.requireNonNull(dataSchemaNode);
        DataSchemaNode dataSchemaNode2 = dataSchemaNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnydataSchemaNode.class, AnyxmlSchemaNode.class, ChoiceSchemaNode.class, ContainerSchemaNode.class, LeafSchemaNode.class, LeafListSchemaNode.class, ListSchemaNode.class, SchemaContext.class}, (Object)dataSchemaNode2, n)) {
            case 0 -> {
                AnydataSchemaNode anydata = (AnydataSchemaNode)dataSchemaNode2;
                yield new ValueNodeModificationStrategy<AnydataSchemaNode, AnydataNode>(AnydataNode.class, anydata);
            }
            case 1 -> {
                AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)dataSchemaNode2;
                yield new ValueNodeModificationStrategy<AnyxmlSchemaNode, AnyxmlNode>(AnyxmlNode.class, anyxml);
            }
            case 2 -> {
                ChoiceSchemaNode choice = (ChoiceSchemaNode)dataSchemaNode2;
                yield new ChoiceModificationStrategy(choice, treeConfig);
            }
            case 3 -> {
                ContainerSchemaNode container = (ContainerSchemaNode)dataSchemaNode2;
                yield ContainerModificationStrategy.of(container, treeConfig);
            }
            case 4 -> {
                LeafSchemaNode leaf = (LeafSchemaNode)dataSchemaNode2;
                yield new ValueNodeModificationStrategy<LeafSchemaNode, LeafNode>(LeafNode.class, leaf);
            }
            case 5 -> {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataSchemaNode2;
                yield MinMaxElementsValidation.from(new LeafSetModificationStrategy(leafList, treeConfig));
            }
            case 6 -> {
                ListSchemaNode list = (ListSchemaNode)dataSchemaNode2;
                yield SchemaAwareApplyOperation.fromListSchemaNode(list, treeConfig);
            }
            case 7 -> {
                SchemaContext context = (SchemaContext)dataSchemaNode2;
                yield new ContainerModificationStrategy.Structural((ContainerLike)context, treeConfig);
            }
            default -> throw new IllegalStateException("Unsupported schema " + String.valueOf(schemaNode));
        };
    }

    static void checkConflicting(ModificationPath path, boolean condition, String message) throws ConflictingModificationAppliedException {
        if (!condition) {
            throw new ConflictingModificationAppliedException(path.toInstanceIdentifier(), message);
        }
    }

    private static ModificationApplyOperation fromListSchemaNode(ListSchemaNode schemaNode, DataTreeConfiguration treeConfig) {
        List keyDefinition = schemaNode.getKeyDefinition();
        SchemaAwareApplyOperation strategy = keyDefinition == null || keyDefinition.isEmpty() ? new ListModificationStrategy(schemaNode, treeConfig) : MapModificationStrategy.of(schemaNode, treeConfig);
        return UniqueValidation.of(schemaNode, treeConfig, MinMaxElementsValidation.from(strategy));
    }

    protected static final void checkNotConflicting(ModificationPath path, @NonNull TreeNode original, @NonNull TreeNode current) throws ConflictingModificationAppliedException {
        SchemaAwareApplyOperation.checkConflicting(path, original.incarnation().equals(current.incarnation()), "Node was replaced by other transaction.");
        SchemaAwareApplyOperation.checkConflicting(path, original.subtreeVersion().equals(current.subtreeVersion()), "Node children was modified by other transaction");
    }

    protected final @NonNull ModificationApplyOperation resolveChildOperation(YangInstanceIdentifier.PathArgument child) {
        ModificationApplyOperation potential = this.childByArg(child);
        Preconditions.checkArgument((potential != null ? 1 : 0) != 0, (String)"Operation for child %s is not defined.", (Object)child);
        return potential;
    }

    @Override
    final void checkApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        switch (modification.getOperation()) {
            case DELETE: {
                SchemaAwareApplyOperation.checkDeleteApplicable(modification, currentMeta);
                break;
            }
            case TOUCH: {
                this.checkTouchApplicable(path, modification, currentMeta, version);
                break;
            }
            case WRITE: {
                SchemaAwareApplyOperation.checkWriteApplicable(path, modification, currentMeta, version);
                break;
            }
            case MERGE: {
                this.checkMergeApplicable(path, modification, currentMeta, version);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Suplied modification type " + String.valueOf((Object)modification.getOperation()) + " is not supported.");
            }
        }
    }

    @Override
    final void quickVerifyStructure(NormalizedNode writtenValue) {
        this.verifyValue(writtenValue);
    }

    @Override
    final void fullVerifyStructure(NormalizedNode writtenValue) {
        this.verifyValue(writtenValue);
        this.verifyValueChildren(writtenValue);
    }

    abstract void verifyValue(NormalizedNode var1);

    void verifyValueChildren(NormalizedNode writtenValue) {
    }

    protected void checkMergeApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        TreeNode orig = modification.original();
        if (orig != null && currentMeta != null && !orig.data().equals((Object)currentMeta.data())) {
            SchemaAwareApplyOperation.checkNotConflicting(path, orig, currentMeta);
        }
    }

    private static void checkWriteApplicable(ModificationPath path, NodeModification modification, TreeNode currentMeta, Version version) throws DataValidationFailedException {
        TreeNode original = modification.original();
        if (original != null && currentMeta != null) {
            SchemaAwareApplyOperation.checkNotConflicting(path, original, currentMeta);
        } else {
            SchemaAwareApplyOperation.checkConflicting(path, original == null, "Node was deleted by other transaction.");
            SchemaAwareApplyOperation.checkConflicting(path, currentMeta == null, "Node was created by other transaction.");
        }
    }

    private static void checkDeleteApplicable(NodeModification modification, @Nullable TreeNode currentMeta) {
        if (currentMeta == null) {
            LOG.trace("Delete operation turned to no-op on missing node {}", (Object)modification);
        }
    }

    @Override
    TreeNode apply(ModifiedNode modification, TreeNode currentMeta, Version version) {
        return switch (modification.getOperation()) {
            default -> throw new MatchException(null, null);
            case LogicalOperation.DELETE -> {
                modification.resolveModificationType(currentMeta != null ? ModificationType.DELETE : ModificationType.UNMODIFIED);
                yield modification.setSnapshot(null);
            }
            case LogicalOperation.TOUCH -> {
                if (currentMeta == null) {
                    throw new IllegalArgumentException("Metadata not available for modification " + String.valueOf(modification));
                }
                yield modification.setSnapshot(this.applyTouch(modification, currentMeta, version));
            }
            case LogicalOperation.MERGE -> {
                TreeNode result;
                if (currentMeta == null) {
                    modification.resolveModificationType(ModificationType.WRITE);
                    result = this.applyWrite(modification, modification.getValue(), null, version);
                    this.fullVerifyStructure(result.data());
                } else {
                    result = this.applyMerge(modification, currentMeta, version);
                }
                yield modification.setSnapshot(result);
            }
            case LogicalOperation.WRITE -> {
                modification.resolveModificationType(ModificationType.WRITE);
                yield modification.setSnapshot(this.applyWrite(modification, modification.getValue(), currentMeta, version));
            }
            case LogicalOperation.NONE -> {
                modification.resolveModificationType(ModificationType.UNMODIFIED);
                yield currentMeta;
            }
        };
    }

    protected abstract @NonNull TreeNode applyMerge(ModifiedNode var1, @NonNull TreeNode var2, Version var3);

    protected abstract @NonNull TreeNode applyWrite(ModifiedNode var1, NormalizedNode var2, @Nullable TreeNode var3, Version var4);

    protected abstract @NonNull TreeNode applyTouch(ModifiedNode var1, @NonNull TreeNode var2, Version var3);

    protected abstract void checkTouchApplicable(ModificationPath var1, NodeModification var2, @Nullable TreeNode var3, Version var4) throws DataValidationFailedException;

    abstract @NonNull T getSchema();

    static final boolean belongsToTree(TreeType treeType, DataSchemaNode node) {
        return treeType == TreeType.OPERATIONAL || node.effectiveConfig().orElse(Boolean.TRUE) != false;
    }

    static final @Nullable MandatoryLeafEnforcer enforcerFor(DataSchemaNode schema, DataTreeConfiguration treeConfig) {
        if (treeConfig.isMandatoryNodesValidationEnabled() && schema instanceof DataNodeContainer) {
            boolean includeConfigFalse;
            DataNodeContainer container = (DataNodeContainer)schema;
            boolean bl = includeConfigFalse = treeConfig.getTreeType() == TreeType.OPERATIONAL;
            if (includeConfigFalse || schema.effectiveConfig().orElse(Boolean.TRUE).booleanValue()) {
                return MandatoryLeafEnforcer.forContainer((DataNodeContainer)container, (boolean)includeConfigFalse);
            }
        }
        return null;
    }
}

