/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl.node;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.OrderedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.StoreTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.MutableTreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.SimpleContainerNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.ValueNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;

@NonNullByDefault
public abstract class TreeNode
implements StoreTreeNode<TreeNode> {
    private final NormalizedNode data;
    private final Version incarnation;

    TreeNode(NormalizedNode data, Version incarnation) {
        this.data = Objects.requireNonNull(data);
        this.incarnation = Objects.requireNonNull(incarnation);
    }

    public static final TreeNode of(NormalizedNode data, Version incarnation) {
        NormalizedNode normalizedNode = data;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DistinctNodeContainer.class, OrderedNodeContainer.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                DistinctNodeContainer distinct = (DistinctNodeContainer)normalizedNode2;
                DistinctNodeContainer container = (DistinctNodeContainer)data;
                yield new SimpleContainerNode((NormalizedNode)container, incarnation);
            }
            case 1 -> {
                OrderedNodeContainer ordered = (OrderedNodeContainer)normalizedNode2;
                yield new SimpleContainerNode((NormalizedNode)ordered, incarnation);
            }
            default -> new ValueNode(data, incarnation);
        };
    }

    public final NormalizedNode data() {
        return this.data;
    }

    public final Version incarnation() {
        return this.incarnation;
    }

    public abstract Version subtreeVersion();

    public abstract MutableTreeNode toMutable(Version var1);

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("version", (Object)this.incarnation)).toString();
    }

    abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
}

