/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;

public abstract class LeafRefPath
implements Immutable {
    private static final VarHandle LEGACYPATH;
    public static final LeafRefPath ROOT;
    public static final LeafRefPath SAME;
    private final LeafRefPath parent;
    private final QNameWithPredicate qname;
    private final int hash;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile ImmutableList<QNameWithPredicate> legacyPath;

    protected LeafRefPath(LeafRefPath parent, QNameWithPredicate qname) {
        this.parent = parent;
        this.qname = qname;
        int hc = Objects.hashCode(parent);
        if (qname != null) {
            hc = hc * 31 + qname.hashCode();
        }
        this.hash = hc;
    }

    public static LeafRefPath create(Iterable<QNameWithPredicate> path, boolean absolute) {
        LeafRefPath parent = absolute ? ROOT : SAME;
        return parent.createChild(path);
    }

    public static LeafRefPath create(boolean absolute, QNameWithPredicate ... path) {
        return LeafRefPath.create(Arrays.asList(path), absolute);
    }

    protected abstract LeafRefPath createInstance(LeafRefPath var1, QNameWithPredicate var2);

    public LeafRefPath createChild(Iterable<QNameWithPredicate> relative) {
        if (Iterables.isEmpty(relative)) {
            return this;
        }
        LeafRefPath newParent = this;
        for (QNameWithPredicate relativeQname : relative) {
            newParent = newParent.createInstance(newParent, relativeQname);
        }
        return newParent;
    }

    public LeafRefPath createChild(LeafRefPath relative) {
        Preconditions.checkArgument((!relative.isAbsolute() ? 1 : 0) != 0, (Object)"Child creation requires relative path");
        LeafRefPath newParent = this;
        for (QNameWithPredicate relativeQname : relative.getPathFromRoot()) {
            newParent = newParent.createInstance(newParent, relativeQname);
        }
        return newParent;
    }

    public LeafRefPath createChild(QNameWithPredicate ... elements) {
        return this.createChild(Arrays.asList(elements));
    }

    public Iterable<QNameWithPredicate> getPathFromRoot() {
        ImmutableList<QNameWithPredicate> local = LEGACYPATH.getAcquire(this);
        return local != null ? local : this.loadLegacyPath();
    }

    private ImmutableList<QNameWithPredicate> loadLegacyPath() {
        ImmutableList ret = ImmutableList.copyOf(this.getPathTowardsRoot()).reverse();
        ImmutableList witness = LEGACYPATH.compareAndExchangeRelease(this, null, ret);
        return witness != null ? witness : ret;
    }

    public Iterable<QNameWithPredicate> getPathTowardsRoot() {
        return () -> new Iterator<QNameWithPredicate>(){
            private LeafRefPath current;
            {
                this.current = LeafRefPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current.parent != null;
            }

            @Override
            public QNameWithPredicate next() {
                if (this.current.parent == null) {
                    throw new NoSuchElementException("No more elements available");
                }
                QNameWithPredicate ret = this.current.qname;
                this.current = this.current.parent;
                return ret;
            }
        };
    }

    public LeafRefPath getParent() {
        return this.parent;
    }

    public final QNameWithPredicate getLastComponent() {
        return this.qname;
    }

    public abstract boolean isAbsolute();

    public final int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LeafRefPath other = (LeafRefPath)obj;
        return Objects.equals(this.qname, other.qname) && Objects.equals(this.parent, other.parent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isAbsolute() ? "Absolute path:" : "Relative path:");
        for (QNameWithPredicate qnameWithPredicate : this.getPathFromRoot()) {
            sb.append('/').append(qnameWithPredicate);
        }
        return sb.toString();
    }

    static {
        try {
            LEGACYPATH = MethodHandles.lookup().findVarHandle(LeafRefPath.class, "legacyPath", ImmutableList.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        ROOT = new AbsoluteLeafRefPath(null, null);
        SAME = new RelativeLeafRefPath(null, null);
    }

    private static final class AbsoluteLeafRefPath
    extends LeafRefPath {
        private AbsoluteLeafRefPath(LeafRefPath parent, QNameWithPredicate qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        protected LeafRefPath createInstance(LeafRefPath newParent, QNameWithPredicate newQname) {
            return new AbsoluteLeafRefPath(newParent, newQname);
        }
    }

    private static final class RelativeLeafRefPath
    extends LeafRefPath {
        private RelativeLeafRefPath(LeafRefPath parent, QNameWithPredicate qname) {
            super(parent, qname);
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        protected LeafRefPath createInstance(LeafRefPath newParent, QNameWithPredicate newQname) {
            return new RelativeLeafRefPath(newParent, newQname);
        }
    }
}

