/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.leafref;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.tree.leafref.LeafRefPath;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNamePredicateBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicate;
import org.opendaylight.yangtools.yang.data.tree.leafref.QNameWithPredicateBuilder;
import org.opendaylight.yangtools.yang.data.tree.leafref.SimpleQNameWithPredicate;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangPathExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;

final class LeafRefPathParserImpl {
    private final QNameModule leafrefModule;
    private final QNameModule nodeModule;

    LeafRefPathParserImpl(LeafrefTypeDefinition leafrefType, TypedDataSchemaNode currentNode) {
        this.leafrefModule = LeafRefPathParserImpl.getBaseModule(leafrefType);
        this.nodeModule = currentNode.getQName().getModule();
    }

    LeafRefPath parseLeafRefPath(PathExpression path) {
        PathExpression.Steps steps = path.getSteps();
        Objects.requireNonNull(steps);
        PathExpression.Steps steps2 = steps;
        int n = 0;
        return this.parseLocationPath((switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PathExpression.LocationPathSteps.class, PathExpression.DerefSteps.class}, (Object)steps2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> (PathExpression.LocationPathSteps)steps2;
            case 1 -> {
                PathExpression.DerefSteps deref = (PathExpression.DerefSteps)steps2;
                throw new UnsupportedOperationException("deref() leafrefs are not implemented yet");
            }
        }).getLocationPath());
    }

    private LeafRefPath parseLocationPath(YangLocationPath locationPath) {
        return LeafRefPath.create(LeafRefPathParserImpl.createPathSteps(locationPath.isAbsolute() ? this.leafrefModule : this.nodeModule, (ImmutableList<YangLocationPath.Step>)locationPath.getSteps()), locationPath.isAbsolute());
    }

    private static ArrayDeque<QNameWithPredicate> createPathSteps(QNameModule localModule, ImmutableList<YangLocationPath.Step> steps) {
        ArrayDeque<QNameWithPredicate> path = new ArrayDeque<QNameWithPredicate>(steps.size());
        block4: for (YangLocationPath.Step step : steps) {
            switch (step.getAxis()) {
                case CHILD: {
                    if (step instanceof YangLocationPath.QNameStep) {
                        YangLocationPath.QNameStep qname = (YangLocationPath.QNameStep)step;
                        path.add(LeafRefPathParserImpl.adaptChildStep(qname, localModule));
                        continue block4;
                    }
                    throw new IllegalStateException("Unsupported step " + String.valueOf(step));
                }
                case PARENT: {
                    path.add(QNameWithPredicate.UP_PARENT);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unsupported axis in step " + String.valueOf(step));
        }
        return path;
    }

    private static QNameWithPredicate adaptChildStep(YangLocationPath.QNameStep step, QNameModule localModule) {
        QName qname = LeafRefPathParserImpl.resolve(step.getQName(), localModule);
        Set predicates = step.getPredicates();
        if (predicates.isEmpty()) {
            return new SimpleQNameWithPredicate(qname);
        }
        QNameWithPredicateBuilder builder = new QNameWithPredicateBuilder(qname.getModule(), qname.getLocalName());
        for (YangExpr pred : predicates) {
            QNamePredicateBuilder predBuilder = new QNamePredicateBuilder();
            if (pred instanceof YangBinaryExpr) {
                YangExpr yangExpr;
                YangBinaryExpr eqPred = (YangBinaryExpr)pred;
                Preconditions.checkState((eqPred.getOperator() == YangBinaryOperator.EQUALS ? 1 : 0) != 0);
                YangExpr left = eqPred.getLeftExpr();
                Preconditions.checkState((boolean)(left instanceof YangQNameExpr), (String)"Unsupported left expression %s", (Object)left);
                predBuilder.setIdentifier(LeafRefPathParserImpl.resolve(((YangQNameExpr)left).getQName(), localModule));
                YangExpr right = eqPred.getRightExpr();
                Objects.requireNonNull(right);
                int n = 0;
                block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangPathExpr.class}, (Object)yangExpr, n)) {
                    case 0: {
                        YangExpr yangExpr2;
                        YangPathExpr rightPath = (YangPathExpr)yangExpr;
                        YangExpr filter = rightPath.getFilterExpr();
                        Objects.requireNonNull(filter);
                        int n2 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangFunctionCallExpr.class}, (Object)yangExpr2, n2)) {
                            case 0: {
                                YangFunctionCallExpr call = (YangFunctionCallExpr)yangExpr2;
                                Preconditions.checkState((boolean)YangFunction.CURRENT.getIdentifier().equals((Object)call.getName()));
                                YangLocationPath.Relative location = (YangLocationPath.Relative)rightPath.getLocationPath().orElseThrow(() -> new IllegalStateException("Missing locationPath in " + String.valueOf(rightPath)));
                                predBuilder.setPathKeyExpression(LeafRefPath.create(LeafRefPathParserImpl.createPathSteps(localModule, (ImmutableList<YangLocationPath.Step>)location.getSteps()), false));
                                break block0;
                            }
                        }
                        throw new IllegalStateException("Unhandled filter " + String.valueOf(filter));
                    }
                    default: {
                        throw new UnsupportedOperationException("Not implemented for " + String.valueOf(right));
                    }
                }
            }
            builder.addQNamePredicate(predBuilder.build());
        }
        return builder.build();
    }

    private static QName resolve(AbstractQName aqname, QNameModule localModule) {
        AbstractQName abstractQName = aqname;
        Objects.requireNonNull(abstractQName);
        AbstractQName abstractQName2 = abstractQName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QName.class, UnresolvedQName.Qualified.class, UnresolvedQName.Unqualified.class}, (Object)abstractQName2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                QName qname;
                yield qname = (QName)abstractQName2;
            }
            case 1 -> {
                UnresolvedQName.Qualified qualified = (UnresolvedQName.Qualified)abstractQName2;
                throw new IllegalStateException("Unhandled unresolved QName " + String.valueOf(qualified));
            }
            case 2 -> {
                UnresolvedQName.Unqualified unqualified = (UnresolvedQName.Unqualified)abstractQName2;
                yield unqualified.bindTo(localModule).intern();
            }
        };
    }

    private static QNameModule getBaseModule(LeafrefTypeDefinition leafrefType) {
        LeafrefTypeDefinition current = leafrefType;
        LeafrefTypeDefinition base;
        while ((base = (LeafrefTypeDefinition)current.getBaseType()) != null) {
            current = base;
        }
        return current.getQName().getModule();
    }
}

