/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.Ops4jException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.swissbox.bnd.OverwriteMode;
import org.ops4j.pax.url.war.internal.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class AbstractConnection
extends URLConnection {
    private static final Logger LOG = LoggerFactory.getLogger(BndUtils.class);
    private final Configuration m_configuration;
    private static DocumentBuilderFactory dbf = null;
    private static final Pattern[] blacklist = new Pattern[]{Pattern.compile("servlet\\.jar"), Pattern.compile("servlet-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("servlet-api\\.jar"), Pattern.compile("servlet-api-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("jasper\\.jar"), Pattern.compile("jasper-[0-9]+(\\.[0-9])+\\.jar"), Pattern.compile("jsp-api\\.jar"), Pattern.compile("jsp-api-[0-9]+(\\.[0-9])+\\.jar")};

    protected AbstractConnection(URL url, Configuration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        NullArgumentException.validateNotNull(configuration, "Configuration");
        String path = url.getPath();
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot empty");
        }
        this.m_configuration = configuration;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        Properties instructions = this.getInstructions();
        PreConditionException.validateNotNull(instructions, "Instructions");
        String warUri = instructions.getProperty("WAR-URL");
        if (warUri == null || warUri.trim().length() == 0) {
            throw new IOException("Instructions file must contain a property named WAR-URL");
        }
        String manifestVersion = instructions.getProperty("Bundle-ManifestVersion");
        if (manifestVersion != null && !"2".equals(manifestVersion)) {
            throw new IllegalArgumentException("Can't support Bundle-ManifestVersion: " + manifestVersion);
        }
        AbstractConnection.generateClassPathInstruction(instructions);
        AbstractConnection.generateImportPackageFromWebXML(instructions);
        return this.createBundle(URLUtils.prepareInputStream(new URL(warUri), this.m_configuration.getCertificateCheck() == false), instructions, warUri);
    }

    protected InputStream createBundle(InputStream inputStream, Properties instructions, String warUri) throws IOException {
        return BndUtils.createBundle(inputStream, instructions, warUri);
    }

    protected InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo, OverwriteMode overwriteMode) throws IOException {
        NullArgumentException.validateNotNull(jarInputStream, "Jar URL");
        NullArgumentException.validateNotNull(instructions, "Instructions");
        NullArgumentException.validateNotEmpty(jarInfo, "Jar info");
        LOG.debug("Creating bundle for [" + jarInfo + "]");
        LOG.debug("Overwrite mode: " + (Object)((Object)overwriteMode));
        LOG.trace("Using instructions " + instructions);
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = null;
        try {
            manifest = jar.getManifest();
        }
        catch (Exception e) {
            jar.close();
            throw new Ops4jException(e);
        }
        if (manifest == null || OverwriteMode.KEEP != overwriteMode || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)instructions);
            properties.put("Generated-By-Ops4j-Pax-From", jarInfo);
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            if (manifest != null && OverwriteMode.MERGE == overwriteMode) {
                analyzer.mergeManifest(manifest);
            }
            AbstractConnection.checkMandatoryProperties(analyzer, jar, jarInfo);
            try {
                Manifest newManifest = analyzer.calcManifest();
                for (Map.Entry<String, Attributes> e : newManifest.getEntries().entrySet()) {
                    Attributes attrs = e.getValue();
                    for (Object k : attrs.keySet()) {
                        String key = k.toString();
                        if (!key.matches("^[a-zA-Z0-9-]+-Digest(-[a-zA-Z0-9]+)?")) continue;
                        attrs.remove(k);
                    }
                }
                jar.setManifest(newManifest);
            }
            catch (Exception e) {
                jar.close();
                throw new Ops4jException(e);
            }
        }
        return AbstractConnection.createInputStream(jar);
    }

    private static PipedInputStream createInputStream(final Jar jar) throws IOException {
        final CloseAwarePipedInputStream pin = new CloseAwarePipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            @Override
            public void run() {
                try {
                    jar.write(pout);
                }
                catch (Exception e) {
                    if (pin.closed) {
                        LOG.debug("Bundle cannot be generated, pipe closed by reader", (Throwable)e);
                    } else {
                        LOG.warn("Bundle cannot be generated", (Throwable)e);
                    }
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error("Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", "*");
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", localSymbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_"));
    }

    protected abstract Properties getInstructions() throws IOException;

    protected Configuration getConfiguration() {
        return this.m_configuration;
    }

    private static void generateClassPathInstruction(Properties instructions) throws IOException {
        ArrayList<String> bundleClassPath = new ArrayList<String>();
        bundleClassPath.addAll(AbstractConnection.toList(instructions.getProperty("Bundle-ClassPath"), ","));
        boolean needsDefault = bundleClassPath.isEmpty();
        if (needsDefault) {
            bundleClassPath.add("WEB-INF/classes");
            bundleClassPath.addAll(AbstractConnection.extractJarListFromWar(instructions.getProperty("WAR-URL")));
        }
        instructions.setProperty("Bundle-ClassPath", AbstractConnection.join(bundleClassPath, ","));
    }

    private static void generateImportPackageFromWebXML(Properties instructions) throws IOException {
        String warUri = instructions.getProperty("WAR-URL");
        ZipFile jarFile = null;
        ArrayList<String> webXmlImports = new ArrayList<String>();
        try {
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/").openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!"WEB-INF/web.xml".equalsIgnoreCase(entry.getName())) continue;
                if (dbf == null) {
                    dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setValidating(false);
                    dbf.setAttribute("http://xml.org/sax/features/namespaces", true);
                    dbf.setAttribute("http://xml.org/sax/features/validation", false);
                    dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(((JarFile)jarFile).getInputStream(entry));
                NodeList childNodes = doc.getDocumentElement().getChildNodes();
                AbstractConnection.parseChildNodes(webXmlImports, childNodes);
                break;
            }
            StringBuffer buff = new StringBuffer(instructions.getProperty("Import-Package"));
            for (String importPackage : webXmlImports) {
                if (buff.toString().contains(importPackage)) continue;
                buff.append(",");
                buff.append(importPackage);
                buff.append(";resolution:=optional");
            }
            instructions.setProperty("Import-Package", buff.toString());
        }
        catch (ClassCastException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (MalformedURLException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (IOException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        catch (SAXException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file", e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void parseChildNodes(List<String> webXmlImports, NodeList childNodes) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String nodeName;
            Node node = childNodes.item(i);
            NodeList subNodes = node.getChildNodes();
            if (subNodes != null) {
                AbstractConnection.parseChildNodes(webXmlImports, subNodes);
            }
            if (!(nodeName = node.getNodeName()).contains("-class")) continue;
            String lookupClass = node.getTextContent();
            String packageName = lookupClass.substring(0, lookupClass.lastIndexOf(".")).trim();
            webXmlImports.add(packageName);
        }
    }

    @Override
    public void connect() {
    }

    private static List<String> extractJarListFromWar(String warUri) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ZipFile jarFile = null;
        HashSet<String> webInfLibJars = new HashSet<String>();
        try {
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/").openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                while (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if (!name.endsWith(".jar") || !AbstractConnection.checkJarIsLegal(name) || !name.startsWith("WEB-INF/lib/")) continue;
                webInfLibJars.add(name);
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        LinkedList<String> toProcess = new LinkedList<String>();
        HashSet<String> processed = new HashSet<String>();
        toProcess.addAll(webInfLibJars);
        processed.addAll(webInfLibJars);
        while (!toProcess.isEmpty()) {
            String jarName = (String)toProcess.remove();
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/" + jarName).openConnection();
            conn.setUseCaches(false);
            try {
                JarFile jf = conn.getJarFile();
                Throwable throwable = null;
                try {
                    ZipEntry entry = jf.getEntry(jarName);
                    try {
                        InputStream is = jf.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            list.add(jarName);
                            JarInputStream embeddedJar = new JarInputStream(is);
                            String cp = embeddedJar.getManifest().getMainAttributes().getValue("Class-Path");
                            String[] cpTab = cp.split("\\s*,\\s*");
                            Path root = Paths.get("/", jarName).getParent();
                            for (String elem : cpTab) {
                                if (!elem.startsWith("/")) {
                                    Path newJar = root.resolve(elem).normalize();
                                    elem = newJar.toString();
                                }
                                while (elem.startsWith("/")) {
                                    elem = elem.substring(1);
                                }
                                if (!processed.add(elem)) continue;
                                toProcess.add(elem);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (is == null) continue;
                            if (throwable2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            is.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jf == null) continue;
                    if (throwable != null) {
                        try {
                            jf.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jf.close();
                }
            }
            catch (Exception exception) {}
        }
        return list;
    }

    protected static boolean checkJarIsLegal(String name) {
        Pattern pattern;
        boolean isMatched = false;
        Pattern[] patternArray = blacklist;
        int n = patternArray.length;
        for (int i = 0; i < n && !(isMatched = (pattern = patternArray[i]).matcher(name).find()); ++i) {
        }
        return !isMatched;
    }

    protected static List<String> toList(String separatedString, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (separatedString != null) {
            list.addAll(Arrays.asList(separatedString.split(delimiter)));
        }
        return list;
    }

    protected static String join(Collection<String> strings, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static final class CloseAwarePipedInputStream
    extends PipedInputStream {
        private boolean closed = false;

        private CloseAwarePipedInputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

