/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.schema.osgi.impl.ModelContextListener;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.osgi.OSGiModuleInfoSnapshot;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class OSGiDOMSchemaService
implements DOMSchemaService,
DOMSchemaService.YangTextSourceExtension {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMSchemaService.class);
    private final List<ModelContextListener> listeners = new CopyOnWriteArrayList<ModelContextListener>();
    private final AtomicReference<ModuleInfoSnapshot> currentSnapshot = new AtomicReference();
    private final ComponentFactory<ModelContextListener> listenerFactory;
    private boolean deactivated;

    @Activate
    public OSGiDOMSchemaService(@Reference(target="(component.factory=org.opendaylight.mdsal.dom.schema.osgi.impl.SchemaSchemaContextListener)") ComponentFactory<ModelContextListener> listenerFactory) {
        this.listenerFactory = Objects.requireNonNull(listenerFactory);
        LOG.info("DOM Schema services activated");
    }

    public List<DOMSchemaService.Extension> supportedExtensions() {
        return List.of(this);
    }

    @Deactivate
    void deactivate() {
        LOG.info("DOM Schema services deactivated");
        this.deactivated = true;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void bindSnapshot(OSGiModuleInfoSnapshot newContext) {
        LOG.info("Updating context to generation {}", (Object)newContext.generation());
        ModuleInfoSnapshot snapshot = (ModuleInfoSnapshot)newContext.service();
        EffectiveModelContext modelContext = snapshot.modelContext();
        ModuleInfoSnapshot previous = this.currentSnapshot.getAndSet(snapshot);
        LOG.debug("Snapshot updated from {} to {}", (Object)previous, (Object)snapshot);
        this.listeners.forEach(listener -> listener.onModelContextUpdated(modelContext));
    }

    void unbindSnapshot(OSGiModuleInfoSnapshot oldContext) {
        ModuleInfoSnapshot snapshot = (ModuleInfoSnapshot)oldContext.service();
        if (this.currentSnapshot.compareAndSet(snapshot, null) && !this.deactivated) {
            LOG.info("Lost final generation {}", (Object)oldContext.generation());
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void addListener(ModelContextListener listener) {
        LOG.trace("Adding listener {}", (Object)listener);
        this.listeners.add(listener);
        listener.onModelContextUpdated(this.getGlobalContext());
    }

    void removeListener(ModelContextListener listener) {
        LOG.trace("Removing listener {}", (Object)listener);
        this.listeners.remove((Object)listener);
    }

    public @NonNull EffectiveModelContext getGlobalContext() {
        return this.currentSnapshot.get().modelContext();
    }

    public Registration registerSchemaContextListener(Consumer<EffectiveModelContext> listener) {
        final ComponentInstance reg = this.listenerFactory.newInstance(ModelContextListener.props(listener));
        return new AbstractRegistration(this){

            protected void removeRegistration() {
                reg.dispose();
            }
        };
    }

    public ListenableFuture<YangTextSource> getYangTexttSource(SourceIdentifier sourceId) {
        try {
            return Futures.immediateFuture((Object)this.currentSnapshot.get().getYangTextSource(sourceId));
        }
        catch (MissingSchemaSourceException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }
}

