/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.layout;

import java.io.IOException;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.layout.AbstractLayout;
import org.apache.karaf.audit.util.Buffer;
import org.apache.karaf.audit.util.FastDateFormat;

public class Rfc3164Layout
extends AbstractLayout {
    public static final int DEFAULT_ENTERPRISE_NUMBER = 18060;
    protected final int facility;
    protected final int priority;
    protected final int enterpriseNumber;
    protected final FastDateFormat fastDateFormat;
    protected String hdr1;
    protected String hdr2;
    protected String hdr3;

    public Rfc3164Layout(int facility, int priority, int enterpriseNumber, TimeZone timeZone, Locale locale) {
        super(new Buffer(Buffer.Format.Syslog));
        this.facility = facility;
        this.priority = priority;
        this.enterpriseNumber = enterpriseNumber;
        this.fastDateFormat = new FastDateFormat(timeZone, locale);
        this.hdr1 = "<" + ((facility << 3) + priority) + ">";
        this.hdr2 = " " + this.hostName + " " + this.appName + " " + this.procId + " ";
        this.hdr3 = enterpriseNumber > 0 ? "@" + enterpriseNumber : "";
    }

    @Override
    protected void header(Event event) throws IOException {
        this.buffer.append(this.hdr1);
        this.datetime(event.timestamp());
        this.buffer.append(this.hdr2);
        this.buffer.append(event.type());
        this.buffer.append(' ');
        this.buffer.append('[');
        this.buffer.append(event.type());
        this.buffer.append(this.hdr3);
    }

    @Override
    protected void footer(Event event) throws IOException {
        this.buffer.append(']');
    }

    @Override
    protected void append(String key, Object val) throws IOException {
        if (val != null) {
            this.buffer.append(' ').append(key).append('=').append('\"').format(val).append('\"');
        }
    }

    protected void datetime(long millis) throws IOException {
        this.buffer.append(this.fastDateFormat.getDate(millis, "MMM d2"));
        this.buffer.append(' ');
        this.fastDateFormat.writeTime(millis, false, this.buffer);
    }
}

