/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.KeyAware;

public record NodeStep<T extends DataObject>(@NonNull Class<T> type, @Nullable Class<? extends DataObject> caseType) implements ExactDataObjectStep<T>
{
    public NodeStep(@NonNull Class<T> type, @Nullable Class<? extends DataObject> caseType) {
        NodeStep.checkType(type, false);
        NodeStep.checkCaseType(caseType);
    }

    public NodeStep(@NonNull Class<T> type) {
        this(type, null);
    }

    static void checkType(Class<?> type, boolean keyAware) {
        if (!DataObject.class.isAssignableFrom(type) || KeyAware.class.isAssignableFrom(type) != keyAware) {
            throw new IllegalArgumentException("Invalid type " + String.valueOf(type));
        }
    }

    static void checkCaseType(@Nullable Class<?> caseType) {
        if (caseType != null && !DataObject.class.isAssignableFrom(caseType)) {
            throw new IllegalArgumentException("Invalid case type " + String.valueOf(caseType));
        }
    }
}

