/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DatastoreShardId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResultKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class ShardResultBuilder {
    private DataStoreType _dataStoreType;
    private String _errorMessage;
    private String _shardName;
    private Boolean _succeeded;
    private ShardResultKey key;
    Map<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> augmentation = Map.of();

    public ShardResultBuilder() {
    }

    public ShardResultBuilder(ShardOperationResult arg) {
        this._succeeded = arg.getSucceeded();
        this._errorMessage = arg.getErrorMessage();
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public ShardResultBuilder(DatastoreShardId arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
    }

    public ShardResultBuilder(ShardResult base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>>(aug);
        }
        this.key = base.key();
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
        this._errorMessage = base.getErrorMessage();
        this._succeeded = base.getSucceeded();
    }

    public void fieldsFrom(Grouping arg) {
        DatastoreShardId castArg;
        boolean isValidArg = false;
        if (arg instanceof ShardOperationResult) {
            castArg = (ShardOperationResult)arg;
            this._succeeded = castArg.getSucceeded();
            this._errorMessage = castArg.getErrorMessage();
            isValidArg = true;
        }
        if (arg instanceof DatastoreShardId) {
            castArg = (DatastoreShardId)arg;
            this._shardName = castArg.getShardName();
            this._dataStoreType = castArg.getDataStoreType();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[ShardOperationResult, DatastoreShardId]");
    }

    public ShardResultKey key() {
        return this.key;
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getShardName() {
        return this._shardName;
    }

    public Boolean getSucceeded() {
        return this._succeeded;
    }

    public <E$$ extends Augmentation<ShardResult>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ShardResultBuilder withKey(ShardResultKey key) {
        this.key = key;
        return this;
    }

    public ShardResultBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    public ShardResultBuilder setErrorMessage(String value) {
        this._errorMessage = value;
        return this;
    }

    private static void check_shardNameLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    public ShardResultBuilder setShardName(String value) {
        if (value != null) {
            ShardResultBuilder.check_shardNameLength(value);
        }
        this._shardName = value;
        return this;
    }

    public ShardResultBuilder setSucceeded(Boolean value) {
        this._succeeded = value;
        return this;
    }

    public ShardResultBuilder addAugmentation(Augmentation<ShardResult> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ShardResultBuilder removeAugmentation(Class<? extends Augmentation<ShardResult>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ShardResult build() {
        return new ShardResultImpl(this);
    }

    private static final class ShardResultImpl
    extends AbstractEntryObject<ShardResult, ShardResultKey>
    implements ShardResult {
        private final DataStoreType _dataStoreType;
        private final String _errorMessage;
        private final String _shardName;
        private final Boolean _succeeded;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ShardResultImpl(ShardResultBuilder base) {
            super(base.augmentation, (Key)ShardResultImpl.extractKey(base));
            ShardResultKey key = (ShardResultKey)this.key();
            this._dataStoreType = key.getDataStoreType();
            this._shardName = key.getShardName();
            this._errorMessage = base.getErrorMessage();
            this._succeeded = base.getSucceeded();
        }

        private static @NonNull ShardResultKey extractKey(ShardResultBuilder base) {
            ShardResultKey key = base.key();
            return key != null ? key : new ShardResultKey(base.getDataStoreType(), base.getShardName());
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getErrorMessage() {
            return this._errorMessage;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        @Override
        public Boolean getSucceeded() {
            return this._succeeded;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ShardResult.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ShardResult.bindingEquals(this, obj);
        }

        public String toString() {
            return ShardResult.bindingToString(this);
        }
    }
}

