/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import java.security.AccessController;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract sealed class AccessControllerCompat {
    private static final AccessControllerCompat INSTANCE;

    public static final <T> T get(Supplier<T> supplier) {
        return INSTANCE.privilegedGet(supplier);
    }

    abstract <T> T privilegedGet(Supplier<T> var1);

    static {
        String str;
        if (Runtime.version().feature() >= 24) {
            str = ">=24";
            INSTANCE = new NoAccessController();
        } else {
            str = "<24";
            INSTANCE = new WithAccessController();
        }
        LoggerFactory.getLogger(AccessControllerCompat.class).debug("Assuming Java {} AccessController semantics", (Object)str);
    }

    private static final class NoAccessController
    extends AccessControllerCompat {
        private NoAccessController() {
        }

        @Override
        <T> T privilegedGet(Supplier<T> supplier) {
            return supplier.get();
        }
    }

    private static final class WithAccessController
    extends AccessControllerCompat {
        private WithAccessController() {
        }

        @Override
        <T> T privilegedGet(Supplier<T> supplier) {
            return (T)AccessController.doPrivileged(supplier::get);
        }
    }
}

