/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContextFactory;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointException;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractDynamicMountPointContextFactory
extends AbstractSimpleIdentifiable<MountPointLabel>
implements MountPointContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDynamicMountPointContextFactory.class);

    protected AbstractDynamicMountPointContextFactory(@NonNull MountPointLabel label) {
        super((Object)label);
    }

    public final MountPointContext createContext(Map<MountPointContextFactory.ContainerName, MountPointChild> libraryContainers, MountPointChild schemaMounts) throws MountPointException {
        for (Map.Entry<MountPointContextFactory.ContainerName, MountPointChild> entry : libraryContainers.entrySet()) {
            NormalizedNode mountData;
            NormalizedNode libData;
            Optional<EffectiveModelContext> optLibContext = this.findSchemaForLibrary(entry.getKey());
            if (optLibContext.isEmpty()) {
                LOG.debug("YANG Library context for mount point {} container {} not found", this.getIdentifier(), (Object)entry.getKey());
                continue;
            }
            try {
                libData = entry.getValue().normalizeTo(optLibContext.orElseThrow());
            }
            catch (IOException e) {
                throw new MountPointException("Failed to interpret yang-library data", (Throwable)e);
            }
            if (!(libData instanceof ContainerNode)) {
                throw new MountPointException("Invalid yang-library non-container " + String.valueOf(libData));
            }
            ContainerNode libContainer = (ContainerNode)libData;
            EffectiveModelContext schemaContext = this.bindLibrary(entry.getKey(), libContainer);
            if (schemaMounts == null) {
                return MountPointContext.of((EffectiveModelContext)schemaContext);
            }
            try {
                mountData = schemaMounts.normalizeTo(schemaContext);
            }
            catch (IOException e) {
                throw new MountPointException("Failed to interpret schema-mount data", (Throwable)e);
            }
            if (!(mountData instanceof ContainerNode)) {
                throw new MountPointException("Invalid schema-mount non-container " + String.valueOf(mountData));
            }
            return this.createMountPointContext(schemaContext, (ContainerNode)mountData);
        }
        throw new MountPointException("Failed to interpret " + String.valueOf(libraryContainers));
    }

    protected abstract @NonNull MountPointContext createMountPointContext(@NonNull EffectiveModelContext var1, @NonNull ContainerNode var2);

    protected abstract @NonNull EffectiveModelContext bindLibrary(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MountPointContextFactory.ContainerName var1, @NonNull ContainerNode var2) throws MountPointException;

    protected abstract Optional<EffectiveModelContext> findSchemaForLibrary(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MountPointContextFactory.ContainerName var1);
}

