/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.io.IOException;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.MultipleEntryDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class ListNodeDataWithSchema
extends CompositeNodeDataWithSchema<ListSchemaNode>
implements MultipleEntryDataWithSchema<ListEntryNodeDataWithSchema> {
    ListNodeDataWithSchema(ListSchemaNode schema) {
        super(schema);
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, NormalizedNodeStreamWriter.MetadataExtension metaWriter) throws IOException {
        ListSchemaNode schema = (ListSchemaNode)this.getSchema();
        writer.nextDataSchemaNode((DataSchemaNode)schema);
        if (schema.getKeyDefinition().isEmpty()) {
            writer.startUnkeyedList(this.provideNodeIdentifier(), this.childSizeHint());
        } else if (schema.isUserOrdered()) {
            writer.startOrderedMapNode(this.provideNodeIdentifier(), this.childSizeHint());
        } else {
            writer.startMapNode(this.provideNodeIdentifier(), this.childSizeHint());
        }
        super.write(writer, metaWriter);
        writer.endNode();
    }

    @Override
    public ListEntryNodeDataWithSchema newChildEntry() {
        ListEntryNodeDataWithSchema child = ListEntryNodeDataWithSchema.forSchema((ListSchemaNode)this.getSchema());
        this.addChild(child);
        return child;
    }
}

