/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.codec;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

@Beta
public final class PrecomputedCodecCache<T>
extends CodecCache<T> {
    private final Map<TypeDefinition<?>, T> simpleCodecs;
    private final Map<SchemaNode, T> complexCodecs;

    PrecomputedCodecCache(Map<TypeDefinition<?>, T> simpleCodecs, Map<SchemaNode, T> complexCodecs) {
        this.simpleCodecs = Objects.requireNonNull(simpleCodecs);
        this.complexCodecs = Objects.requireNonNull(complexCodecs);
    }

    @Override
    <S extends SchemaNode & TypeAware> T lookupComplex(S schema) {
        T ret = this.complexCodecs.get(schema);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"No codec available for schema %s", schema);
        return ret;
    }

    @Override
    T lookupSimple(TypeDefinition<?> type) {
        return this.simpleCodecs.get(type);
    }

    @Override
    <S extends SchemaNode & TypeAware> T getComplex(S schema, T codec) {
        throw new IllegalStateException("Uncached codec for " + String.valueOf(schema));
    }

    @Override
    T getSimple(TypeDefinition<?> type, T codec) {
        throw new IllegalStateException("Uncached codec for " + String.valueOf(type));
    }

    public int complexSize() {
        return this.complexCodecs.size();
    }

    public int simpleSize() {
        return this.simpleCodecs.size();
    }
}

