/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.context;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.context.AbstractContext;
import org.opendaylight.yangtools.yang.data.util.context.ContainerContext;
import org.opendaylight.yangtools.yang.data.util.context.ListItemContext;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract sealed class AbstractCompositeContext
extends AbstractContext
implements DataSchemaContext.Composite
permits ListItemContext, ContainerContext {
    private final ConcurrentMap<YangInstanceIdentifier.PathArgument, AbstractContext> byArg = new ConcurrentHashMap<YangInstanceIdentifier.PathArgument, AbstractContext>();
    private final ConcurrentMap<QName, AbstractContext> byQName = new ConcurrentHashMap<QName, AbstractContext>();
    private final DataNodeContainer container;

    AbstractCompositeContext(YangInstanceIdentifier.NodeIdentifier pathStep, DataNodeContainer container, DataSchemaNode schema) {
        super(pathStep, schema);
        this.container = Objects.requireNonNull(container);
    }

    @Override
    public final AbstractContext childByArg(YangInstanceIdentifier.PathArgument arg) {
        AbstractContext existing = (AbstractContext)this.byArg.get(Objects.requireNonNull(arg));
        if (existing != null) {
            return existing;
        }
        return this.register(this.fromLocalSchema(arg));
    }

    @Override
    public final AbstractContext childByQName(QName qname) {
        AbstractContext existing = (AbstractContext)this.byQName.get(Objects.requireNonNull(qname));
        if (existing != null) {
            return existing;
        }
        return this.register(AbstractCompositeContext.fromLocalSchemaAndQName(this.container, qname));
    }

    @Override
    public final AbstractContext enterChild(SchemaInferenceStack stack, QName qname) {
        return AbstractCompositeContext.pushToStack(stack, this.childByQName(qname));
    }

    @Override
    public final AbstractContext enterChild(SchemaInferenceStack stack, YangInstanceIdentifier.PathArgument arg) {
        return AbstractCompositeContext.pushToStack(stack, this.childByArg(arg));
    }

    private static AbstractContext pushToStack(SchemaInferenceStack stack, AbstractContext child) {
        Objects.requireNonNull(stack);
        if (child != null) {
            child.pushToStack(stack);
        }
        return child;
    }

    private AbstractContext fromLocalSchema(YangInstanceIdentifier.PathArgument child) {
        return AbstractCompositeContext.fromSchemaAndQNameChecked(this.container, child.getNodeType());
    }

    private static AbstractContext fromLocalSchemaAndQName(DataNodeContainer schema, QName child) {
        return AbstractCompositeContext.fromSchemaAndQNameChecked(schema, child);
    }

    private AbstractContext register(AbstractContext potential) {
        if (potential != null) {
            this.byArg.put((YangInstanceIdentifier.PathArgument)potential.getPathStep(), potential);
            for (QName qname : potential.qnameIdentifiers()) {
                this.byQName.put(qname, potential);
            }
        }
        return potential;
    }
}

