/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util.context;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContext;
import org.opendaylight.yangtools.yang.data.util.context.AbstractCompositeContext;
import org.opendaylight.yangtools.yang.data.util.context.AbstractPathMixinContext;
import org.opendaylight.yangtools.yang.data.util.context.AbstractValueContext;
import org.opendaylight.yangtools.yang.data.util.context.ChoiceContext;
import org.opendaylight.yangtools.yang.data.util.context.ContainerContext;
import org.opendaylight.yangtools.yang.data.util.context.LeafContext;
import org.opendaylight.yangtools.yang.data.util.context.LeafListContext;
import org.opendaylight.yangtools.yang.data.util.context.ListContext;
import org.opendaylight.yangtools.yang.data.util.context.MapContext;
import org.opendaylight.yangtools.yang.data.util.context.OpaqueContext;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract sealed class AbstractContext
implements DataSchemaContext
permits AbstractPathMixinContext, AbstractCompositeContext, AbstractValueContext, OpaqueContext {
    private final YangInstanceIdentifier.NodeIdentifier pathStep;
    final @NonNull DataSchemaNode dataSchemaNode;

    AbstractContext(YangInstanceIdentifier.NodeIdentifier pathStep, DataSchemaNode dataSchemaNode) {
        this.dataSchemaNode = Objects.requireNonNull(dataSchemaNode);
        this.pathStep = pathStep;
    }

    @Override
    public final DataSchemaNode dataSchemaNode() {
        return this.dataSchemaNode;
    }

    @Override
    public final YangInstanceIdentifier.NodeIdentifier pathStep() {
        return this.pathStep;
    }

    ImmutableSet<QName> qnameIdentifiers() {
        return ImmutableSet.of((Object)this.dataSchemaNode.getQName());
    }

    void pushToStack(@NonNull SchemaInferenceStack stack) {
        stack.enterSchemaTree(this.dataSchemaNode.getQName());
    }

    static AbstractContext fromSchemaAndQNameChecked(DataNodeContainer schema, QName child) {
        return AbstractContext.lenientOf(AbstractContext.findChildSchemaNode(schema, child));
    }

    private static DataSchemaNode findChildSchemaNode(DataNodeContainer parent, QName child) {
        DataSchemaNode potential = parent.dataChildByName(child);
        return potential == null ? AbstractContext.findChoice(Iterables.filter((Iterable)parent.getChildNodes(), ChoiceSchemaNode.class), child) : potential;
    }

    private static ChoiceSchemaNode findChoice(Iterable<ChoiceSchemaNode> choices, QName child) {
        for (ChoiceSchemaNode choice : choices) {
            for (CaseSchemaNode caze : choice.getCases()) {
                if (AbstractContext.findChildSchemaNode((DataNodeContainer)caze, child) == null) continue;
                return choice;
            }
        }
        return null;
    }

    public static @NonNull AbstractContext of(@NonNull DataSchemaNode schema) {
        DataSchemaNode dataSchemaNode = schema;
        Objects.requireNonNull(dataSchemaNode);
        DataSchemaNode dataSchemaNode2 = dataSchemaNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnydataSchemaNode.class, AnyxmlSchemaNode.class, ChoiceSchemaNode.class, ContainerLike.class, LeafSchemaNode.class, LeafListSchemaNode.class, ListSchemaNode.class}, (Object)dataSchemaNode2, n)) {
            case 0 -> {
                AnydataSchemaNode anydata = (AnydataSchemaNode)dataSchemaNode2;
                yield new OpaqueContext((DataSchemaNode)anydata);
            }
            case 1 -> {
                AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)dataSchemaNode2;
                yield new OpaqueContext((DataSchemaNode)anyxml);
            }
            case 2 -> {
                ChoiceSchemaNode choice = (ChoiceSchemaNode)dataSchemaNode2;
                yield new ChoiceContext(choice);
            }
            case 3 -> {
                ContainerLike containerLike = (ContainerLike)dataSchemaNode2;
                yield new ContainerContext(containerLike);
            }
            case 4 -> {
                LeafSchemaNode leaf = (LeafSchemaNode)dataSchemaNode2;
                yield new LeafContext(leaf);
            }
            case 5 -> {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataSchemaNode2;
                yield new LeafListContext(leafList);
            }
            case 6 -> {
                ListSchemaNode list = (ListSchemaNode)dataSchemaNode2;
                yield AbstractContext.fromListSchemaNode(list);
            }
            default -> throw new IllegalStateException("Unhandled schema " + String.valueOf(schema));
        };
    }

    private static @Nullable AbstractContext lenientOf(@Nullable DataSchemaNode schema) {
        DataSchemaNode dataSchemaNode = schema;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnydataSchemaNode.class, AnyxmlSchemaNode.class, ChoiceSchemaNode.class, ContainerLike.class, LeafSchemaNode.class, LeafListSchemaNode.class, ListSchemaNode.class}, (Object)dataSchemaNode, n)) {
            case 0 -> {
                AnydataSchemaNode anydata = (AnydataSchemaNode)dataSchemaNode;
                yield new OpaqueContext((DataSchemaNode)anydata);
            }
            case 1 -> {
                AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)dataSchemaNode;
                yield new OpaqueContext((DataSchemaNode)anyxml);
            }
            case 2 -> {
                ChoiceSchemaNode choice = (ChoiceSchemaNode)dataSchemaNode;
                yield new ChoiceContext(choice);
            }
            case 3 -> {
                ContainerLike containerLike = (ContainerLike)dataSchemaNode;
                yield new ContainerContext(containerLike);
            }
            case 4 -> {
                LeafSchemaNode leaf = (LeafSchemaNode)dataSchemaNode;
                yield new LeafContext(leaf);
            }
            case 5 -> {
                LeafListSchemaNode leafList = (LeafListSchemaNode)dataSchemaNode;
                yield new LeafListContext(leafList);
            }
            case 6 -> {
                ListSchemaNode list = (ListSchemaNode)dataSchemaNode;
                yield AbstractContext.fromListSchemaNode(list);
            }
            default -> null;
        };
    }

    private static @NonNull AbstractContext fromListSchemaNode(ListSchemaNode potential) {
        List keyDefinition = potential.getKeyDefinition();
        return keyDefinition.isEmpty() ? new ListContext(potential) : new MapContext(potential);
    }
}

