/*
 * Decompiled with CFR 0.152.
 */
package ntfbenchmark.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import ntfbenchmark.impl.AbstractNtfbenchProducer;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.yangtools.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtfbenchNonblockingProducer
extends AbstractNtfbenchProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NtfbenchNonblockingProducer.class);

    public NtfbenchNonblockingProducer(NotificationPublishService publishService, int iterations, int payloadSize) {
        super(publishService, iterations, payloadSize);
    }

    @Override
    public void run() {
        int ntfOk = 0;
        int ntfError = 0;
        ListenableFuture lastOkFuture = null;
        for (int i = 0; i < this.iterations; ++i) {
            try {
                ListenableFuture result = this.publishService.offerNotification((Notification)this.ntf);
                if (NotificationPublishService.REJECTED == result) {
                    ++ntfError;
                    continue;
                }
                ++ntfOk;
                lastOkFuture = result;
                continue;
            }
            catch (Exception e) {
                LOG.debug("Failed to publish notification", (Throwable)e);
                ++ntfError;
            }
        }
        this.ntfOk = ntfOk;
        this.ntfError = ntfError;
        if (lastOkFuture != null) {
            try {
                lastOkFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

