/*
 * Decompiled with CFR 0.152.
 */
package ntfbenchmark.impl;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import ntfbenchmark.impl.AbstractNtfbenchProducer;
import ntfbenchmark.impl.NtfbenchBlockingProducer;
import ntfbenchmark.impl.NtfbenchTestListener;
import ntfbenchmark.impl.NtfbenchWTCListener;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbench.payload.rev150709.Ntfbench;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ntfbenchmark.rev150105.TestStatusOutput;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
@RequireServiceComponentRuntime
public final class NtfbenchmarkProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NtfbenchmarkProvider.class);
    private static final int TEST_TIMEOUT = 5;
    private final NotificationService listenService;
    private final NotificationPublishService publishService;
    private final Registration reg;

    @Inject
    @Activate
    public NtfbenchmarkProvider(@Reference NotificationService listenService, @Reference NotificationPublishService publishService, @Reference RpcProviderService rpcService) {
        this.listenService = Objects.requireNonNull(listenService);
        this.publishService = Objects.requireNonNull(publishService);
        this.reg = rpcService.registerRpcImplementations(new Rpc[]{this::testStatus, this::startTest});
        LOG.debug("NtfbenchmarkProvider initiated");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.reg.close();
        LOG.info("NtfbenchmarkProvider closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        int producerCount = input.getProducers().intValue();
        int listenerCount = input.getListeners().intValue();
        int iterations = input.getIterations().intValue();
        int payloadSize = input.getIterations().intValue();
        ArrayList<NtfbenchBlockingProducer> producers = new ArrayList<NtfbenchBlockingProducer>(producerCount);
        for (int i = 0; i < producerCount; ++i) {
            producers.add(new NtfbenchBlockingProducer(this.publishService, iterations, payloadSize));
        }
        int expectedCntPerListener = producerCount * iterations;
        ArrayList<NtfbenchTestListener> listeners = new ArrayList<NtfbenchTestListener>(listenerCount);
        ArrayList<Registration> registrations = new ArrayList<Registration>(listenerCount);
        for (int i = 0; i < listenerCount; ++i) {
            NtfbenchTestListener listener = input.getProducerType() == StartTestInput.ProducerType.BLOCKING ? new NtfbenchWTCListener(payloadSize, expectedCntPerListener) : new NtfbenchTestListener(payloadSize);
            listeners.add(listener);
            registrations.add(this.listenService.registerListener(Ntfbench.class, (NotificationService.Listener)listener));
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(input.getProducers().intValue());
            LOG.info("Test Started");
            long startTime = System.nanoTime();
            for (int i = 0; i < input.getProducers().intValue(); ++i) {
                Verify.verifyNotNull(executor.submit((Runnable)producers.get(i)));
            }
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.MINUTES);
                for (NtfbenchTestListener listener : listeners) {
                    listener.getAllDone().get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Out of time: test did not finish within the {} min deadline ", (Object)5, (Object)e);
            }
            long producerEndTime = System.nanoTime();
            long producerElapsedTime = producerEndTime - startTime;
            long allListeners = 0L;
            long allProducersOk = 0L;
            long allProducersError = 0L;
            for (NtfbenchTestListener listener : listeners) {
                allListeners += (long)listener.getReceived();
            }
            long listenerElapsedTime = producerEndTime - startTime;
            LOG.info("Test Done");
            for (AbstractNtfbenchProducer fluentFuture : producers) {
                allProducersOk += (long)fluentFuture.getNtfOk();
                allProducersError += (long)fluentFuture.getNtfError();
            }
            StartTestOutput output = new StartTestOutputBuilder().setProducerElapsedTime(Uint32.valueOf((long)(producerElapsedTime / 1000000L))).setListenerElapsedTime(Uint32.valueOf((long)(listenerElapsedTime / 1000000L))).setListenerOk(Uint32.valueOf((long)allListeners)).setProducerOk(Uint32.valueOf((long)allProducersOk)).setProducerError(Uint32.valueOf((long)allProducersError)).setProducerRate(Uint32.valueOf((long)((allProducersOk + allProducersError) * 1000000000L / producerElapsedTime))).setListenerRate(Uint32.valueOf((long)(allListeners * 1000000000L / listenerElapsedTime))).build();
            FluentFuture fluentFuture = RpcResultBuilder.success((Object)output).buildFuture();
            return fluentFuture;
        }
        finally {
            registrations.forEach(Registration::close);
        }
    }

    private ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

