/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONValue;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONValueWriter;
import org.opendaylight.yangtools.yang.data.util.codec.IdentityCodecUtil;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

final class IdentityrefJSONCodec
implements JSONCodec<QName> {
    private final @NonNull EffectiveModelContext context;
    private final @NonNull QNameModule parentModule;

    IdentityrefJSONCodec(EffectiveModelContext context, QNameModule parentModule) {
        this.context = Objects.requireNonNull(context);
        this.parentModule = Objects.requireNonNull(parentModule);
    }

    public Class<QName> getDataType() {
        return QName.class;
    }

    @Override
    public QName parseValue(String value) {
        return IdentityCodecUtil.parseIdentity((String)value, (EffectiveModelContext)this.context, prefix -> {
            if (prefix.isEmpty()) {
                return this.parentModule;
            }
            Iterator modules = this.context.findModuleStatements(prefix).iterator();
            Preconditions.checkArgument((boolean)modules.hasNext(), (String)"Could not find module %s", (Object)prefix);
            return ((ModuleEffectiveStatement)modules.next()).localQNameModule();
        }).getQName();
    }

    @Override
    public JSONValue unparseValue(QName value) {
        return new JSONValue(this.encode(value), JSONValue.Kind.STRING);
    }

    @Override
    public void writeValue(JSONValueWriter ctx, QName value) throws IOException {
        ctx.writeString(this.encode(value));
    }

    private @NonNull String encode(QName value) {
        return QNameCodecUtil.encodeQName((QName)value, uri -> this.context.findModuleStatement(uri).map(module -> ((UnresolvedQName.Unqualified)module.argument()).getLocalName()).orElseThrow(() -> new IllegalArgumentException("Cannot find module for " + String.valueOf(uri))));
    }
}

