/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Verify;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.builder.NormalizedNodeContainerBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationException;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.BooleanJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.EmptyJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.IdentityrefJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.InstanceIdentifierJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.codec.gson.NumberJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.UnionJSONCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.AbstractIntegerStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BinaryStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BitsStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.BooleanStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DataStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.DecimalStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.EnumStringCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.StringStringCodec;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.util.codec.AbstractInputStreamNormalizer;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.LazyCodecCache;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public abstract sealed class JSONCodecFactory
extends AbstractInputStreamNormalizer<JSONCodec<?>> {
    private final @NonNull InstanceIdentifierJSONCodec iidCodec;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/1867")
    private JSONCodecFactory(@NonNull EffectiveModelContext context, @NonNull CodecCache<JSONCodec<?>> cache, BiFunction<EffectiveModelContext, JSONCodecFactory, @NonNull InstanceIdentifierJSONCodec> iidCodec) {
        super(context, cache);
        this.iidCodec = (InstanceIdentifierJSONCodec)Verify.verifyNotNull((Object)iidCodec.apply(context, this));
    }

    protected final JSONCodec<?> binaryCodec(BinaryTypeDefinition type) {
        return new QuotedJSONCodec(BinaryStringCodec.from((BinaryTypeDefinition)type));
    }

    protected final JSONCodec<?> booleanCodec(BooleanTypeDefinition type) {
        return new BooleanJSONCodec((DataStringCodec<Boolean>)BooleanStringCodec.from((BooleanTypeDefinition)type));
    }

    protected final JSONCodec<?> bitsCodec(BitsTypeDefinition type) {
        return new QuotedJSONCodec(BitsStringCodec.from((BitsTypeDefinition)type));
    }

    protected final JSONCodec<?> decimalCodec(DecimalTypeDefinition type) {
        return this.wrapDecimalCodec(DecimalStringCodec.from((DecimalTypeDefinition)type));
    }

    protected final JSONCodec<?> emptyCodec(EmptyTypeDefinition type) {
        return EmptyJSONCodec.INSTANCE;
    }

    protected final JSONCodec<?> enumCodec(EnumTypeDefinition type) {
        return new QuotedJSONCodec(EnumStringCodec.from((EnumTypeDefinition)type));
    }

    protected final JSONCodec<QName> identityRefCodec(IdentityrefTypeDefinition type, QNameModule module) {
        return new IdentityrefJSONCodec(this.modelContext(), module);
    }

    protected final JSONCodec<YangInstanceIdentifier> instanceIdentifierCodec(InstanceIdentifierTypeDefinition type) {
        return this.iidCodec;
    }

    public JSONCodec<YangInstanceIdentifier> instanceIdentifierCodec() {
        return this.iidCodec;
    }

    protected final JSONCodec<?> int8Codec(Int8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int8TypeDefinition)type));
    }

    protected final JSONCodec<?> int16Codec(Int16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int16TypeDefinition)type));
    }

    protected final JSONCodec<?> int32Codec(Int32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Int32TypeDefinition)type));
    }

    protected final JSONCodec<?> int64Codec(Int64TypeDefinition type) {
        return this.wrapIntegerCodec(AbstractIntegerStringCodec.from((Int64TypeDefinition)type));
    }

    protected final JSONCodec<?> stringCodec(StringTypeDefinition type) {
        return new QuotedJSONCodec(StringStringCodec.from((StringTypeDefinition)type));
    }

    protected final JSONCodec<?> uint8Codec(Uint8TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint8TypeDefinition)type));
    }

    protected final JSONCodec<?> uint16Codec(Uint16TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint16TypeDefinition)type));
    }

    protected final JSONCodec<?> uint32Codec(Uint32TypeDefinition type) {
        return new NumberJSONCodec(AbstractIntegerStringCodec.from((Uint32TypeDefinition)type));
    }

    protected final JSONCodec<?> uint64Codec(Uint64TypeDefinition type) {
        return this.wrapIntegerCodec(AbstractIntegerStringCodec.from((Uint64TypeDefinition)type));
    }

    protected final JSONCodec<?> unionCodec(UnionTypeDefinition type, List<JSONCodec<?>> codecs) {
        return UnionJSONCodec.create(type, codecs);
    }

    final JSONCodecFactory rebaseTo(EffectiveModelContext newSchemaContext) {
        return this.rebaseTo(newSchemaContext, (CodecCache<JSONCodec<?>>)new LazyCodecCache());
    }

    abstract JSONCodecFactory rebaseTo(EffectiveModelContext var1, CodecCache<JSONCodec<?>> var2);

    abstract JSONCodec<?> wrapDecimalCodec(DecimalStringCodec var1);

    abstract JSONCodec<?> wrapIntegerCodec(AbstractIntegerStringCodec<?, ?> var1);

    protected final NormalizationResult<ContainerNode> parseDatastore(InputStream stream, YangInstanceIdentifier.NodeIdentifier containerName, UnresolvedQName.Unqualified moduleName) throws IOException, NormalizationException {
        NormalizationResult normalizationResult;
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            reader.beginObject();
            String name = reader.nextName();
            String expected = moduleName.getLocalName() + ":" + containerName.getNodeType().getLocalName();
            if (!expected.equals(name)) {
                throw NormalizationException.ofMessage((String)("Expected name '" + expected + "', got '" + name + "'"));
            }
            DataContainerNodeBuilder builder = ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)containerName);
            if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                try (NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeContainerBuilder)builder);){
                    try (JsonParserStream parser = JsonParserStream.create(writer, this);){
                        parser.parse(reader);
                    }
                    catch (JsonParseException e) {
                        throw NormalizationException.ofCause((Throwable)e);
                    }
                }
            }
            reader.endObject();
            JsonToken nextToken = reader.peek();
            if (nextToken != JsonToken.END_DOCUMENT) {
                throw NormalizationException.ofMessage((String)("Expected end of JSON document, got " + String.valueOf(nextToken)));
            }
            normalizationResult = new NormalizationResult((NormalizedNode)((ContainerNode)builder.build()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalStateException e) {
                throw NormalizationException.ofCause((Throwable)e);
            }
        }
        reader.close();
        return normalizationResult;
    }

    protected final NormalizationResult<?> parseData(SchemaInferenceStack stack, InputStream stream) throws IOException, NormalizationException {
        stack.exit();
        return this.parseStream((EffectiveStatementInference)stack.toInference(), stream);
    }

    protected final NormalizationResult<?> parseChildData(InputStream stream, EffectiveStatementInference inference) throws IOException, NormalizationException {
        return this.parseStream(inference, stream);
    }

    protected final NormalizationResult<?> parseInputOutput(SchemaInferenceStack stack, QName expected, InputStream stream) throws IOException, NormalizationException {
        return JSONCodecFactory.checkNodeName(this.parseStream((EffectiveStatementInference)stack.toInference(), stream), (QName)expected);
    }

    private @NonNull NormalizationResult<?> parseStream(@NonNull EffectiveStatementInference inference, @NonNull InputStream stream) throws IOException, NormalizationException {
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));){
            NormalizationResultHolder holder = new NormalizationResultHolder();
            try (NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)holder);){
                try (JsonParserStream parser = JsonParserStream.create(writer, this, inference);){
                    parser.parse(reader);
                }
                catch (JsonParseException e) {
                    throw NormalizationException.ofCause((Throwable)e);
                }
            }
            NormalizationResult normalizationResult = holder.getResult();
            return normalizationResult;
        }
    }

    static final class RFC7951
    extends JSONCodecFactory {
        RFC7951(@NonNull EffectiveModelContext context, @NonNull CodecCache<JSONCodec<?>> cache) {
            super(context, cache, InstanceIdentifierJSONCodec.RFC7951::new);
        }

        @Override
        RFC7951 rebaseTo(EffectiveModelContext newSchemaContext, CodecCache<JSONCodec<?>> newCache) {
            return new RFC7951(newSchemaContext, newCache);
        }

        @Override
        JSONCodec<?> wrapDecimalCodec(DecimalStringCodec decimalCodec) {
            return new QuotedJSONCodec(decimalCodec);
        }

        @Override
        JSONCodec<?> wrapIntegerCodec(AbstractIntegerStringCodec<?, ?> integerCodec) {
            return new QuotedJSONCodec(integerCodec);
        }
    }

    @Deprecated(since="12.0.0", forRemoval=true)
    static final class Lhotka02
    extends JSONCodecFactory {
        Lhotka02(@NonNull EffectiveModelContext context, @NonNull CodecCache<JSONCodec<?>> cache) {
            super(context, cache, InstanceIdentifierJSONCodec.Lhotka02::new);
        }

        @Override
        Lhotka02 rebaseTo(EffectiveModelContext newSchemaContext, CodecCache<JSONCodec<?>> newCache) {
            return new Lhotka02(newSchemaContext, newCache);
        }

        @Override
        JSONCodec<?> wrapDecimalCodec(DecimalStringCodec decimalCodec) {
            return new NumberJSONCodec(decimalCodec);
        }

        @Override
        JSONCodec<?> wrapIntegerCodec(AbstractIntegerStringCodec<?, ?> integerCodec) {
            return new NumberJSONCodec(integerCodec);
        }
    }
}

