/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.command;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.karaf.profile.Profile;
import org.apache.karaf.profile.ProfileBuilder;
import org.apache.karaf.profile.ProfileService;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="edit", scope="profile", description="Edits the specified profile", detailedDescription="classpath:profileEdit.txt")
@Service
public class ProfileEdit
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileEdit.class);
    static final String DELIMITER = ",";
    static final String PID_KEY_SEPARATOR = "/";
    static final String FILE_INSTALL_FILENAME_PROPERTY = "felix.fileinstall.filename";
    @Option(name="-r", aliases={"--repositories"}, description="Edit the features repositories. To specify multiple repositories, specify this flag multiple times.", required=false, multiValued=true)
    private String[] repositories;
    @Option(name="-f", aliases={"--features"}, description="Edit features. To specify multiple features, specify this flag multiple times. For example, --features foo --features bar.", required=false, multiValued=true)
    private String[] features;
    @Option(name="-l", aliases={"--libs"}, description="Edit libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] libs;
    @Option(name="-n", aliases={"--endorsed"}, description="Edit endorsed libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] endorsed;
    @Option(name="-x", aliases={"--extension"}, description="Edit extension libraries. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] extension;
    @Option(name="-b", aliases={"--bundles"}, description="Edit bundles. To specify multiple bundles, specify this flag multiple times.", required=false, multiValued=true)
    private String[] bundles;
    @Option(name="-o", aliases={"--overrides"}, description="Edit overrides. To specify multiple libraries, specify this flag multiple times.", required=false, multiValued=true)
    private String[] overrides;
    @Option(name="-p", aliases={"--pid"}, description="Edit an OSGi configuration property, specified in the format <PID>/<Property>. To specify multiple properties, specify this flag multiple times.", required=false, multiValued=true)
    private String[] pidProperties;
    @Option(name="-s", aliases={"--system"}, description="Edit the Java system properties that affect installed bundles (analogous to editing etc/system.properties in a root container).", required=false, multiValued=true)
    private String[] systemProperties;
    @Option(name="-c", aliases={"--config"}, description="Edit the Java system properties that affect the karaf container (analogous to editing etc/config.properties in a root container).", required=false, multiValued=true)
    private String[] configProperties;
    @Option(name="-i", aliases={"--import-pid"}, description="Imports the pids that are edited, from local OSGi config admin", required=false, multiValued=false)
    private boolean importPid = false;
    @Option(name="--resource", description="Selects a resource under the profile to edit. This option should only be used alone.", required=false, multiValued=false)
    private String resource;
    @Option(name="--set", description="Set or create values (selected by default).")
    private boolean set = true;
    @Option(name="--delete", description="Delete values. This option can be used to delete a feature, a bundle or a pid from the profile.")
    private boolean delete = false;
    @Option(name="--append", description="Append value to a delimited list. It is only usable with the system, config & pid options")
    private boolean append = false;
    @Option(name="--remove", description="Removes value from a delimited list. It is only usable with the system, config & pid options")
    private boolean remove = false;
    @Option(name="--delimiter", description="Specifies the delimiter to use for appends and removals.")
    private String delimiter = ",";
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Reference
    private ProfileService profileService;
    @Reference
    private ConfigurationAdmin configurationAdmin;
    @Reference
    Terminal terminal;

    public Object execute() throws Exception {
        if (this.delete) {
            this.set = false;
        }
        Profile profile = this.profileService.getRequiredProfile(this.profileName);
        this.editProfile(profile);
        return null;
    }

    private void editProfile(Profile profile) throws Exception {
        boolean editInLine = false;
        ProfileBuilder builder = ProfileBuilder.Factory.createFrom(profile);
        if (this.delete || this.remove) {
            editInLine = true;
        }
        if (this.features != null && this.features.length > 0) {
            editInLine = true;
            this.handleFeatures(builder, this.features, profile);
        }
        if (this.repositories != null && this.repositories.length > 0) {
            editInLine = true;
            this.handleFeatureRepositories(builder, this.repositories, profile);
        }
        if (this.libs != null && this.libs.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.libs, profile, "lib", "library.");
        }
        if (this.endorsed != null && this.endorsed.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.endorsed, profile, "endorsed lib", "endorsed.");
        }
        if (this.extension != null && this.extension.length > 0) {
            editInLine = true;
            this.handleLibraries(builder, this.extension, profile, "extension lib", "ext.");
        }
        if (this.bundles != null && this.bundles.length > 0) {
            editInLine = true;
            this.handleBundles(builder, this.bundles, profile);
        }
        if (this.overrides != null && this.overrides.length > 0) {
            editInLine = true;
            this.handleOverrides(builder, this.overrides, profile);
        }
        if (this.pidProperties != null && this.pidProperties.length > 0) {
            editInLine = this.handlePid(builder, this.pidProperties, profile);
        }
        if (this.systemProperties != null && this.systemProperties.length > 0) {
            editInLine = true;
            this.handleSystemProperties(builder, this.systemProperties, profile);
        }
        if (this.configProperties != null && this.configProperties.length > 0) {
            editInLine = true;
            this.handleConfigProperties(builder, this.configProperties, profile);
        }
        if (!editInLine) {
            if (this.resource == null) {
                this.resource = "profile.cfg";
            }
            if (this.pidProperties != null && this.pidProperties.length == 1) {
                this.resource = this.pidProperties[0] + ".cfg";
            }
            this.openInEditor(profile, this.resource);
        }
        this.profileService.updateProfile(builder.getProfile());
    }

    private void handleFeatures(ProfileBuilder builder, String[] features, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String feature : features) {
            if (this.delete) {
                System.out.println("Deleting feature:" + feature + " from profile:" + profile.getId());
            } else {
                System.out.println("Adding feature:" + feature + " to profile:" + profile.getId());
            }
            this.updateConfig(conf, "feature." + feature.replace('/', '_'), feature, this.set, this.delete);
            builder.addConfiguration("profile", conf);
        }
    }

    private void handleFeatureRepositories(ProfileBuilder builder, String[] repositories, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String repositoryURI : repositories) {
            if (this.set) {
                System.out.println("Adding feature repository:" + repositoryURI + " to profile:" + profile.getId());
            } else if (this.delete) {
                System.out.println("Deleting feature repository:" + repositoryURI + " from profile:" + profile.getId());
            }
            this.updateConfig(conf, "repository." + repositoryURI.replace('/', '_'), repositoryURI, this.set, this.delete);
        }
        builder.addConfiguration("profile", conf);
    }

    private void handleLibraries(ProfileBuilder builder, String[] libs, Profile profile, String libType, String libPrefix) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String lib : libs) {
            if (this.set) {
                System.out.println("Adding " + libType + ":" + lib + " to profile:" + profile.getId());
            } else if (this.delete) {
                System.out.println("Deleting " + libType + ":" + lib + " from profile:" + profile.getId());
            }
            this.updateConfig(conf, libPrefix + lib.replace('/', '_'), lib, this.set, this.delete);
        }
        builder.addConfiguration("profile", conf);
    }

    private void handleBundles(ProfileBuilder builder, String[] bundles, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String bundle : bundles) {
            if (this.set) {
                System.out.println("Adding bundle:" + bundle + " to profile:" + profile.getId());
            } else if (this.delete) {
                System.out.println("Deleting bundle:" + bundle + " from profile:" + profile.getId());
            }
            this.updateConfig(conf, "bundle." + bundle.replace('/', '_'), bundle, this.set, this.delete);
        }
        builder.addConfiguration("profile", conf);
    }

    private void handleOverrides(ProfileBuilder builder, String[] overrides, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String override : overrides) {
            if (this.set) {
                System.out.println("Adding override:" + override + " to profile:" + profile.getId());
            } else if (this.delete) {
                System.out.println("Deleting override:" + override + " from profile:" + profile.getId());
            }
            this.updateConfig(conf, "override." + override.replace('/', '_'), override, this.set, this.delete);
        }
        builder.addConfiguration("profile", conf);
    }

    private boolean handlePid(ProfileBuilder builder, String[] pidProperties, Profile profile) {
        boolean editInline = true;
        for (String pidProperty : pidProperties) {
            String currentPid;
            String keyValuePair = "";
            if (pidProperty.contains(PID_KEY_SEPARATOR)) {
                currentPid = pidProperty.substring(0, pidProperty.indexOf(PID_KEY_SEPARATOR));
                keyValuePair = pidProperty.substring(pidProperty.indexOf(PID_KEY_SEPARATOR) + 1);
            } else {
                currentPid = pidProperty;
            }
            Map<String, Object> conf = this.getConfigurationFromBuilder(builder, currentPid);
            if (pidProperties.length == 1 && this.importPid) {
                System.out.println("Importing pid:" + currentPid + " to profile:" + profile.getId());
                this.importPidFromLocalConfigAdmin(currentPid, conf);
                builder.addConfiguration(currentPid, conf);
                return true;
            }
            Map<String, String> configMap = this.extractConfigs(keyValuePair);
            if (configMap.isEmpty() && this.set) {
                editInline = false;
                continue;
            }
            if (configMap.isEmpty() && this.delete) {
                editInline = true;
                System.out.println("Deleting pid:" + currentPid + " from profile:" + profile.getId());
                builder.deleteConfiguration(currentPid);
                continue;
            }
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (value == null && this.delete) {
                    System.out.println("Deleting key:" + key + " from pid:" + currentPid + " and profile:" + profile.getId());
                    conf.remove(key);
                    continue;
                }
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " to pid:" + currentPid + " and profile:" + profile.getId());
                } else if (this.remove) {
                    System.out.println("Removing value:" + value + " key:" + key + " from pid:" + currentPid + " and profile:" + profile.getId());
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " on pid:" + currentPid + " and profile:" + profile.getId());
                }
                this.updatedDelimitedList(conf, key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
            editInline = true;
            builder.addConfiguration(currentPid, conf);
        }
        return editInline;
    }

    private void handleSystemProperties(ProfileBuilder builder, String[] systemProperties, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String systemProperty : systemProperties) {
            Map<String, String> configMap = this.extractConfigs(systemProperty);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " from system properties and profile:" + profile.getId());
                } else if (this.delete) {
                    System.out.println("Deleting key:" + key + " from system properties and profile:" + profile.getId());
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " from system properties and profile:" + profile.getId());
                } else {
                    System.out.println("Removing value:" + value + " key:" + key + " from system properties and profile:" + profile.getId());
                }
                this.updatedDelimitedList(conf, "system." + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
        }
        builder.addConfiguration("profile", conf);
    }

    private void handleConfigProperties(ProfileBuilder builder, String[] configProperties, Profile profile) {
        Map<String, Object> conf = this.getConfigurationFromBuilder(builder, "profile");
        for (String configProperty : configProperties) {
            Map<String, String> configMap = this.extractConfigs(configProperty);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                String key = configEntries.getKey();
                String value = configEntries.getValue();
                if (this.append) {
                    System.out.println("Appending value:" + value + " key:" + key + " from config properties and profile:" + profile.getId());
                } else if (this.delete) {
                    System.out.println("Deleting key:" + key + " from config properties and profile:" + profile.getId());
                } else if (this.set) {
                    System.out.println("Setting value:" + value + " key:" + key + " from config properties and profile:" + profile.getId());
                }
                this.updatedDelimitedList(conf, "config." + key, value, this.delimiter, this.set, this.delete, this.append, this.remove);
            }
        }
        builder.addConfiguration("profile", conf);
    }

    private void openInEditor(Profile profile, String resource) throws Exception {
    }

    public void updatedDelimitedList(Map<String, Object> map, String key, String value, String delimiter, boolean set, boolean delete, boolean append, boolean remove) {
        if (append || remove) {
            String oldValue = map.containsKey(key) ? (String)map.get(key) : "";
            LinkedList<String> parts = new LinkedList<String>(Arrays.asList(oldValue.split(delimiter)));
            parts.remove("");
            if (append) {
                parts.add(value);
            }
            if (remove) {
                parts.remove(value);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts.size(); ++i) {
                if (i != 0) {
                    sb.append(delimiter);
                }
                sb.append((String)parts.get(i));
            }
            map.put(key, sb.toString());
        } else if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void updateConfig(Map<String, Object> map, String key, Object value, boolean set, boolean delete) {
        if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void importPidFromLocalConfigAdmin(String pid, Map<String, Object> target) {
        try {
            Configuration[] configuration = this.configurationAdmin.listConfigurations("(service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0) {
                Dictionary dictionary = configuration[0].getProcessedProperties(null);
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = String.valueOf(keyEnumeration.nextElement());
                    if (key.equals(FILE_INSTALL_FILENAME_PROPERTY)) continue;
                    String value = String.valueOf(dictionary.get(key));
                    target.put(key, value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while importing configuration {} to profile.", (Object)pid);
        }
    }

    private Map<String, String> extractConfigs(String configs) {
        String value;
        String key;
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (configs.contains("=")) {
            key = configs.substring(0, configs.indexOf("="));
            value = configs.substring(configs.indexOf("=") + 1);
        } else {
            key = configs;
            value = null;
        }
        if (!key.isEmpty()) {
            configMap.put(key, value);
        }
        return configMap;
    }

    private Map<String, Object> getConfigurationFromBuilder(ProfileBuilder builder, String pid) {
        return builder.getConfiguration(pid);
    }
}

