/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.simpletx;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.DomListBuilder;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpletxDomWrite
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpletxDomWrite.class);
    private final DOMDataBroker dataBroker;
    private List<MapEntryNode> list = null;

    public SimpletxDomWrite(DOMDataBroker dataBroker, StartTestInput.Operation oper, int outerListElem, int innerListElem, long putsPerTx, StartTestInput.DataStore dataStore) {
        super(oper, outerListElem, innerListElem, putsPerTx, dataStore);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        LOG.debug("Created SimpletxDomWrite");
    }

    @Override
    public void createList() {
        this.list = DomListBuilder.buildOuterList(this.outerListElem, this.innerListElem);
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        YangInstanceIdentifier pid = YangInstanceIdentifier.of((QName[])new QName[]{TestExec.QNAME, OuterList.QNAME});
        DOMDataTreeWriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        long writeCnt = 0L;
        for (MapEntryNode element : this.list) {
            YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)OuterList.QNAME, (Map)element.name().asMap()));
            if (this.oper == StartTestInput.Operation.PUT) {
                tx.put(dsType, yid, (NormalizedNode)element);
            } else {
                tx.merge(dsType, yid, (NormalizedNode)element);
            }
            if (++writeCnt != this.writesPerTx) continue;
            try {
                tx.commit().get();
                ++this.txOk;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Transaction failed", (Throwable)e);
                ++this.txError;
            }
            tx = this.dataBroker.newWriteOnlyTransaction();
            writeCnt = 0L;
        }
        if (writeCnt != 0L) {
            try {
                tx.commit().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Transaction failed", (Throwable)e);
            }
        }
    }
}

