/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.txchain.TxchainBaWrite;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListKey;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainBaDelete
extends DatastoreAbstractWriter
implements FutureCallback<Empty> {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainBaDelete.class);
    private final DataBroker bindingDataBroker;

    public TxchainBaDelete(DataBroker bindingDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.bindingDataBroker = bindingDataBroker;
        LOG.debug("Created TxchainBaDelete");
    }

    @Override
    public void createList() {
        LOG.debug("TxchainBaDelete: creating data in the data store");
        TxchainBaWrite dd = new TxchainBaWrite(this.bindingDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        TransactionChain chain = this.bindingDataBroker.createMergingTransactionChain();
        chain.addCallback((FutureCallback)this);
        WriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (int l = 0; l < this.outerListElem; ++l) {
            KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Key)new OuterListKey(Integer.valueOf(l)));
            tx.delete(dsType, (InstanceIdentifier)iid);
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    TxchainBaDelete.this.txOk++;
                }

                public void onFailure(Throwable cause) {
                    LOG.error("Transaction failed", cause);
                    TxchainBaDelete.this.txError++;
                }
            }, MoreExecutors.directExecutor());
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            if (writeCnt > 0) {
                ++txSubmitted;
            }
            tx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Transaction failed", (Throwable)e);
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onFailure(Throwable cause) {
        LOG.error("Broken chain in TxchainBaDelete", cause);
    }

    public void onSuccess(Empty chain) {
        LOG.debug("TxchainBaDelete closed successfully");
    }
}

