/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.txchain.TxchainBaWrite;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterListKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.outer.list.InnerList;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainBaRead
extends DatastoreAbstractWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainBaRead.class);
    private final DataBroker bindingDataBroker;

    public TxchainBaRead(DataBroker bindingDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.bindingDataBroker = bindingDataBroker;
        LOG.debug("Created TxchainBaRead");
    }

    @Override
    public void createList() {
        LOG.debug("TxchainBaRead: reading data in the data store");
        TxchainBaWrite dd = new TxchainBaWrite(this.bindingDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        try (ReadTransaction tx = this.bindingDataBroker.newReadOnlyTransaction();){
            for (long l = 0L; l < (long)this.outerListElem; ++l) {
                KeyedInstanceIdentifier iid = InstanceIdentifier.create(TestExec.class).child(OuterList.class, (Key)new OuterListKey(Integer.valueOf((int)l)));
                FluentFuture submitFuture = tx.read(dsType, (InstanceIdentifier)iid);
                try {
                    Optional optionalDataObject = (Optional)submitFuture.get();
                    if (optionalDataObject != null && optionalDataObject.isPresent()) {
                        OuterList outerList = (OuterList)optionalDataObject.orElseThrow();
                        String[] objectsArray = new String[outerList.nonnullInnerList().size()];
                        for (InnerList innerList : outerList.nonnullInnerList().values()) {
                            if (objectsArray[innerList.getName()] != null) {
                                LOG.error("innerList: DUPLICATE name: {}, value: {}", (Object)innerList.getName(), (Object)innerList.getValue());
                            }
                            objectsArray[innerList.getName().intValue()] = innerList.getValue();
                        }
                        for (int i = 0; i < outerList.nonnullInnerList().size(); ++i) {
                            String itemStr = objectsArray[i];
                            if (itemStr.contentEquals("Item-" + l + "-" + i)) continue;
                            LOG.error("innerList: name: {}, value: {}", (Object)i, (Object)itemStr);
                            break;
                        }
                        ++this.txOk;
                        continue;
                    }
                    ++this.txError;
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("failed to ....", (Throwable)e);
                    ++this.txError;
                }
            }
        }
    }
}

