/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.binding.dom.adapter;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipService;
import org.opendaylight.mdsal.eos.binding.dom.adapter.DOMEntityOwnershipListenerAdapter;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component
public final class DefaultEntityOwnershipService
implements EntityOwnershipService {
    private final @NonNull DOMEntityOwnershipService domService;
    private final @NonNull AdapterContext adapterContext;

    @Inject
    @Activate
    public DefaultEntityOwnershipService(@Reference @NonNull DOMEntityOwnershipService domService, @Reference @NonNull AdapterContext adapterContext) {
        this.domService = Objects.requireNonNull(domService);
        this.adapterContext = Objects.requireNonNull(adapterContext);
    }

    public Registration registerCandidate(Entity entity) throws CandidateAlreadyRegisteredException {
        return this.domService.registerCandidate(this.toDOMEntity(entity));
    }

    public Registration registerListener(String entityType, EntityOwnershipListener listener) {
        return this.domService.registerListener(entityType, (DOMEntityOwnershipListener)new DOMEntityOwnershipListenerAdapter(listener, this.adapterContext));
    }

    public Optional<EntityOwnershipState> getOwnershipState(Entity forEntity) {
        return this.domService.getOwnershipState(this.toDOMEntity(forEntity));
    }

    public boolean isCandidateRegistered(Entity forEntity) {
        return this.domService.isCandidateRegistered(this.toDOMEntity(forEntity));
    }

    private @NonNull DOMEntity toDOMEntity(Entity entity) {
        return new DOMEntity(entity.getType(), this.adapterContext.currentSerializer().toYangInstanceIdentifier((DataObjectReference)entity.getIdentifier()));
    }
}

