/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import java.math.BigDecimal;
import org.opendaylight.yangtools.yang.xpath.api.AbstractYangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.BigDecimalNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

final class BigDecimalXPathMathSupport
extends AbstractYangXPathMathSupport<BigDecimalNumberExpr> {
    static final BigDecimalXPathMathSupport INSTANCE = new BigDecimalXPathMathSupport();
    private static final long serialVersionUID = 1L;
    private static final BigDecimalNumberExpr ZERO = BigDecimalNumberExpr.of(BigDecimal.ZERO);
    private static final BigDecimalNumberExpr ONE = BigDecimalNumberExpr.of(BigDecimal.ONE);
    private static final BigDecimalNumberExpr TEN = BigDecimalNumberExpr.of(BigDecimal.TEN);

    private BigDecimalXPathMathSupport() {
        super(BigDecimalNumberExpr.class);
    }

    @Override
    public BigDecimalNumberExpr createNumber(String str) {
        return switch (str) {
            case "0" -> ZERO;
            case "1" -> ONE;
            case "10" -> TEN;
            default -> BigDecimalNumberExpr.of(new BigDecimal(str));
        };
    }

    @Override
    public BigDecimalNumberExpr createNumber(int value) {
        return switch (value) {
            case 0 -> ZERO;
            case 1 -> ONE;
            case 10 -> TEN;
            default -> BigDecimalNumberExpr.of(BigDecimal.valueOf(value));
        };
    }

    @Override
    protected BigDecimalNumberExpr doNegateNumber(BigDecimalNumberExpr number) {
        return BigDecimalNumberExpr.of(number.getNumber().negate());
    }

    @Override
    protected YangExpr doEvaluate(YangBinaryOperator operator, BigDecimalNumberExpr left, BigDecimalNumberExpr right) {
        BigDecimal l = left.getNumber();
        BigDecimal r = right.getNumber();
        return switch (operator) {
            default -> throw new MatchException(null, null);
            case YangBinaryOperator.DIV -> BigDecimalNumberExpr.of(l.divide(r));
            case YangBinaryOperator.EQUALS -> YangBooleanConstantExpr.of(l.equals(r));
            case YangBinaryOperator.GT -> YangBooleanConstantExpr.of(l.compareTo(r) > 0);
            case YangBinaryOperator.GTE -> YangBooleanConstantExpr.of(l.compareTo(r) >= 0);
            case YangBinaryOperator.LT -> YangBooleanConstantExpr.of(l.compareTo(r) < 0);
            case YangBinaryOperator.LTE -> YangBooleanConstantExpr.of(l.compareTo(r) <= 0);
            case YangBinaryOperator.MINUS -> BigDecimalNumberExpr.of(l.subtract(r));
            case YangBinaryOperator.MOD -> BigDecimalNumberExpr.of(l.remainder(r));
            case YangBinaryOperator.MUL -> BigDecimalNumberExpr.of(l.multiply(r));
            case YangBinaryOperator.NOT_EQUALS -> YangBooleanConstantExpr.of(!l.equals(r));
            case YangBinaryOperator.PLUS -> BigDecimalNumberExpr.of(l.add(r));
        };
    }

    @Override
    protected Object readResolve() {
        return INSTANCE;
    }
}

