/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

public abstract sealed class YangBinaryExpr
implements YangExpr
permits YangBinaryOperator.Expr {
    private static final long serialVersionUID = 1L;
    private final YangExpr leftExpr;
    private final YangExpr rightExpr;

    YangBinaryExpr(YangExpr leftExpr, YangExpr rightExpr) {
        this.leftExpr = Objects.requireNonNull(leftExpr);
        this.rightExpr = Objects.requireNonNull(rightExpr);
    }

    public final YangExpr getLeftExpr() {
        return this.leftExpr;
    }

    public final YangExpr getRightExpr() {
        return this.rightExpr;
    }

    public abstract YangBinaryOperator getOperator();

    public final int hashCode() {
        return Objects.hash(new Object[]{this.leftExpr, this.rightExpr, this.getOperator()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangBinaryExpr)) return false;
        YangBinaryExpr other = (YangBinaryExpr)obj;
        if (!this.getOperator().equals((Object)other.getOperator())) return false;
        if (!this.leftExpr.equals(other.leftExpr)) return false;
        if (!this.rightExpr.equals(other.rightExpr)) return false;
        return true;
    }

    public final String toString() {
        return this.leftExpr.toString() + " " + String.valueOf((Object)this.getOperator()) + " " + String.valueOf(this.rightExpr);
    }
}

