/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.query;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryPredicate;
import org.opendaylight.mdsal.dom.spi.query.DOMQueryMatcher;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

@NonNullByDefault
final class DOMQueryIterator
extends AbstractIterator<Map.Entry<YangInstanceIdentifier, NormalizedNode>> {
    private final ArrayDeque<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable YangInstanceIdentifier.PathArgument> remainingSelect = new ArrayDeque();
    private final ArrayDeque<YangInstanceIdentifier.PathArgument> currentPath = new ArrayDeque();
    private final ArrayDeque<Frame> frames = new ArrayDeque();
    private final List<? extends DOMQueryPredicate> predicates;

    DOMQueryIterator(DOMQuery query, NormalizedNode queryRoot) {
        this.remainingSelect.addAll(query.getSelect().getPathArguments());
        this.currentPath.addAll(query.getRoot().getPathArguments());
        this.predicates = query.getPredicates();
        this.frames.push(new Frame(queryRoot));
    }

    protected Map.Entry<YangInstanceIdentifier, NormalizedNode> computeNext() {
        Map.Entry next = this.findNext();
        return next != null ? next : (Map.Entry)this.endOfData();
    }

    private @Nullable Map.Entry<YangInstanceIdentifier, NormalizedNode> findNext() {
        Frame current = this.frames.poll();
        while (current != null) {
            MapEntryNode child;
            YangInstanceIdentifier.PathArgument next = this.remainingSelect.poll();
            if (next == null) {
                Iterator<MapEntryNode> iter = ((MapFrame)current).iter;
                while (iter.hasNext()) {
                    child = iter.next();
                    if (!this.matches((NormalizedNode)child)) continue;
                    return this.pushAndReturn(current, child);
                }
                current = this.unwind(current.select);
                continue;
            }
            if (current instanceof MapFrame) {
                MapEntryNode child2;
                MapFrame mapFrame = (MapFrame)current;
                Iterator<MapEntryNode> iter = mapFrame.iter;
                if (this.remainingSelect.isEmpty()) {
                    while (iter.hasNext()) {
                        child2 = iter.next();
                        if (!this.matches((NormalizedNode)child2)) continue;
                        this.remainingSelect.push(next);
                        return this.pushAndReturn(current, child2);
                    }
                    current = this.unwind(current, next);
                    continue;
                }
                if (iter.hasNext()) {
                    child2 = iter.next();
                    this.frames.push(current);
                    this.currentPath.addLast((YangInstanceIdentifier.PathArgument)child2.name());
                    current = new Frame((NormalizedNode)child2, next);
                    continue;
                }
                current = this.unwind(current, next);
                continue;
            }
            Optional optChild = NormalizedNodes.getDirectChild((NormalizedNode)current.data, (YangInstanceIdentifier.PathArgument)next);
            if (optChild.isEmpty()) {
                current = this.unwind(current, next);
                continue;
            }
            child = (NormalizedNode)optChild.orElseThrow();
            if (this.remainingSelect.isEmpty()) {
                if (this.matches((NormalizedNode)child)) {
                    return this.unwindAndReturn(current, next, (NormalizedNode)child);
                }
                current = this.unwind(current, next);
                continue;
            }
            if (child instanceof MapNode) {
                MapNode map = (MapNode)child;
                YangInstanceIdentifier.PathArgument target = this.remainingSelect.peek();
                if (target instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                    YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)target;
                    MapEntryNode entry = (MapEntryNode)map.childByArg((YangInstanceIdentifier.PathArgument)nip);
                    if (entry != null) {
                        if (this.remainingSelect.size() != 1) {
                            this.remainingSelect.pop();
                            this.frames.push(current);
                            this.currentPath.addLast((YangInstanceIdentifier.PathArgument)map.name());
                            this.frames.push(new Frame((NormalizedNode)map, next));
                            this.currentPath.addLast(target);
                            current = new Frame((NormalizedNode)entry, target);
                            continue;
                        }
                        if (this.matches((NormalizedNode)entry)) {
                            return this.unwindAndReturn(current, next, (NormalizedNode)entry);
                        }
                    }
                    current = this.unwind(current, next);
                    continue;
                }
                this.frames.push(current);
                this.currentPath.addLast(next);
                current = new MapFrame((NormalizedNode)child, next, map.body().iterator());
                continue;
            }
            this.frames.push(current);
            this.currentPath.addLast(child.name());
            current = new Frame((NormalizedNode)child, next);
        }
        Verify.verify((boolean)this.frames.isEmpty());
        this.remainingSelect.clear();
        this.currentPath.clear();
        return null;
    }

    private YangInstanceIdentifier createIdentifier(NormalizedNode child) {
        this.currentPath.addLast(child.name());
        YangInstanceIdentifier ret = YangInstanceIdentifier.of(this.currentPath);
        this.currentPath.removeLast();
        return ret;
    }

    private Map.Entry<YangInstanceIdentifier, NormalizedNode> pushAndReturn(Frame frame, MapEntryNode child) {
        YangInstanceIdentifier childPath = this.createIdentifier((NormalizedNode)child);
        this.frames.push(frame);
        return Map.entry(childPath, child);
    }

    private Map.Entry<YangInstanceIdentifier, NormalizedNode> unwindAndReturn(Frame frame, YangInstanceIdentifier.PathArgument next, NormalizedNode child) {
        YangInstanceIdentifier childPath = this.createIdentifier(child);
        this.unwind(frame, next);
        return Map.entry(childPath, child);
    }

    private @Nullable Frame unwind(Frame current, YangInstanceIdentifier.PathArgument next) {
        this.remainingSelect.push(next);
        return this.unwind(current.select);
    }

    private @Nullable Frame unwind(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable YangInstanceIdentifier.PathArgument selectArg) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable YangInstanceIdentifier.PathArgument select = selectArg;
        while (true) {
            this.currentPath.removeLast();
            if (select == null) {
                Verify.verify((boolean)this.frames.isEmpty());
                return null;
            }
            this.remainingSelect.push(select);
            Frame next = this.frames.pop();
            if (next.hasNext()) {
                return next;
            }
            select = next.select;
        }
    }

    private boolean matches(NormalizedNode data) {
        return DOMQueryMatcher.matchesAll(data, this.predicates);
    }

    private static sealed class Frame
    permits MapFrame {
        final NormalizedNode data;
        final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable YangInstanceIdentifier.PathArgument select;

        @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"}, justification="Ungrokked @Nullable")
        Frame(NormalizedNode data) {
            this.data = Objects.requireNonNull(data);
            this.select = null;
        }

        Frame(NormalizedNode data, YangInstanceIdentifier.PathArgument select) {
            this.data = Objects.requireNonNull(data);
            this.select = Objects.requireNonNull(select);
        }

        boolean hasNext() {
            return false;
        }

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("data", (Object)this.data.name()).add("select", (Object)this.select);
        }
    }

    private static final class MapFrame
    extends Frame {
        final Iterator<MapEntryNode> iter;

        MapFrame(NormalizedNode data, YangInstanceIdentifier.PathArgument select, Iterator<MapEntryNode> iter) {
            super(data, select);
            this.iter = Objects.requireNonNull(iter);
        }

        @Override
        boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("hasNext", this.iter.hasNext());
        }
    }
}

