/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.PemUtils;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;

public class KeyPairVerifier {
    public static void verify(String privateKeyPem, String publicKeyPem) throws VerificationException {
        PublicKey publicKey;
        PrivateKey privateKey;
        try {
            privateKey = PemUtils.decodePrivateKey(privateKeyPem);
        }
        catch (Exception e) {
            throw new VerificationException("Failed to decode private key", e);
        }
        try {
            publicKey = PemUtils.decodePublicKey(publicKeyPem);
        }
        catch (Exception e) {
            throw new VerificationException("Failed to decode public key", e);
        }
        try {
            String jws = new JWSBuilder().content("content".getBytes()).rsa256(privateKey);
            if (!RSAProvider.verify(new JWSInput(jws), publicKey)) {
                throw new VerificationException("Keys don't match");
            }
        }
        catch (Exception e) {
            throw new VerificationException("Keys don't match");
        }
    }
}

